<?php
/**
* Page-description: This php file is used by PHP-Fusion to "install" the infusion. It contains information about the database tables and the infusion itself.
* @package infusion
* @tables dbprefix_invite_invitations, dbprefix_invite_settings
*/
/*---------------------------------------------------+
| PHP-Fusion 6 Content Management System
+----------------------------------------------------+
| Copyright  2002 - 2005 Nick Jones
| http://www.php-fusion.co.uk/
+----------------------------------------------------+
| Released under the terms & conditions of v2 of the
| GNU General Public License. For details refer to
| the included gpl.txt file or visit http://gnu.org
+----------------------------------------------------+
| Invite Infusion made by:
| XtraLars, bigwimp, johanf
+----------------------------------------------------*/
if (!defined("IN_FUSION") || !checkrights("I")) { header("Location: ../../index.php"); exit; }

// Check if locale file is available matching the current site locale setting.
if (file_exists(INFUSIONS."invite_infusion/locale/".$settings['locale'].".php")) {
	// Load the locale file matching the current site locale setting.
	include INFUSIONS."invite_infusion/locale/".$settings['locale'].".php";
} else {
	// Load the infusion's default locale file.
	include INFUSIONS."invite_infusion/locale/English.php";
}

// Infusion general information
$inf_title = $locale['inv100'];
$inf_description = $locale['inv101'];
$inf_version = "0.92";
$inf_developer = "XtraLars, bigwimp, johanf";
$inf_email = "xtralars@baluba.org";
$inf_weburl = "http://beta.baluba.org/";

$inf_folder = "invite_infusion"; // The folder in which the infusion resides.
$inf_admin_image = ""; // Leave blank to use the default image.
$inf_admin_panel = "invite_admin.php"; // The admin panel filename if required.

$inf_link_name = $locale['inv102']; // if not required replace $locale['inv102']; with "";
$inf_link_url = "invite.php"; // The filename you wish to link to.
$inf_link_visibility = "101"; // 0 - Guest / 101 - Member / 102 - Admin / 103 - Super Admin.

$inf_newtables = 2; // Number of new db tables to create or drop.
$inf_insertdbrows = 1; // Numbers rows added into created db tables.
$inf_altertables = 0; // Number of db tables to alter (upgrade).
$inf_deldbrows = 0; // Number of db tables to delete data from.

// Delete any items not required here.
$inf_newtable_[1] = "invite_invitations (
  inv_id SMALLINT(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  inv_key VARCHAR(50) NULL default '',
  inv_email VARCHAR(100) NULL default '',
  inv_date DATE NULL ,
  user_id SMALLINT(5) UNSIGNED NOT NULL,
  PRIMARY KEY(inv_id)
) TYPE=MyISAM;";
$inf_newtable_[2] = "invite_settings (
  inv_group SMALLINT(3) UNSIGNED NOT NULL DEFAULT 101,
  inv_lasts SMALLINT(3) UNSIGNED NOT NULL DEFAULT 10,
  inv_adminapproval BOOL NOT NULL DEFAULT 0,
  inv_emailverification BOOL NULL DEFAULT 0,
  inv_enabled BOOL NULL default 1,
  PRIMARY KEY(inv_group),
  INDEX fusion_invite_settings_FKIndex1(inv_group)
) TYPE=MyISAM;";

$inf_droptable_[1] = "invite_invitations";
$inf_droptable_[2] = "invite_settings";

$inf_insertdbrow_[1] = "invite_settings (inv_group, inv_lasts, inv_adminapproval) VALUES(101, 10, 0)";

//$inf_altertable_[1] = "table_name ADD etc";

//$inf_deldbrow_[1] = "other_table";

?>