<?php
/**
* Page-description: This is the page for the users who have access to inviting other people to the site.
* In an attept to keep security as good as the rest of PHP-Fusion, a lot of code has been copied from files such as register.php in the PHP-Fusion package.
* @package infusion
* @tables dbprefix_invite_invitations, dbprefix_invite_settings
*/
/*---------------------------------------------------+
| PHP-Fusion 6 Content Management System
+----------------------------------------------------+
| Copyright  2002 - 2005 Nick Jones
| http://www.php-fusion.co.uk/
+----------------------------------------------------+
| Released under the terms & conditions of v2 of the
| GNU General Public License. For details refer to
| the included gpl.txt file or visit http://gnu.org
+----------------------------------------------------+
| Invite Infusion made by:
| XtraLars, bigwimp, johanf
+----------------------------------------------------*/
require_once "../../maincore.php";
require_once BASEDIR."subheader.php";
require_once BASEDIR."side_left.php";

if (file_exists(INFUSIONS."invite_infusion/locale/".$settings['locale'].".php")) {
	// Load the locale file matching the current site locale setting.
	include INFUSIONS."invite_infusion/locale/".$settings['locale'].".php";
} else {
	// Load the infusions default locale file.
	include INFUSIONS."invite_infusion/locale/English.php";
}
// INFUSION INCLUDES
define("IN_INVITE", true, true);
require_once INFUSIONS."invite_infusion/toolbox.php";

/**
* Puts a string in a array. Used for debugging
* @name debugLine
* @global string $debugarray The array containing the debug-strings
* @param string [$string] The string to be put in the array
* @author XtraLars <xtralars@baluba.org>
*/
function debugLine($string){
	global $debugarray;
	array_push($debugarray, $string);
}
/**
* Prints the contents of the debug-array in a table - Used for debugging.
* @name debugOut
* @global string $debugarray The array containing the debug-strings
* @author XtraLars <xtralars@baluba.org>
*/
function debugOut() {
	global $debugarray; 
	opentable("### DEBUG");
	foreach ($debugarray as $line) {
		echo $line."<br />\n";
	}
	closetable();
	tablebreak();
}
// START
$debugMode = false;
$debugarray = array();

$sql = "SELECT * FROM ".$db_prefix."invite_settings";
$inv_settings = dbarray(dbquery($sql));
deleteOldInvitations();
if ($inv_settings['inv_enabled'] != "0") {
	if(checkgroup($inv_settings['inv_group'])) {
		if(isset($_POST['btnInvite'])) {
			$inv_email = trim(stripinput($_POST['txtEmail']));
			$error = "";
			$error_free = true;
			$blacklisted = false;
			
			// Check email address:
			if (!preg_match("/^[-0-9A-Z_\.]{1,50}@([-0-9A-Z_\.]+\.){1,50}([0-9A-Z]){2,4}$/i", $inv_email)) { // Code copied from PHP-Fusion package
				$error .= $locale['inv501']."<br />\n";
				$error_free = false;
			} else {
			// E-mail OK, check other things
				// Check Blacklist
				$email_domain = substr(strrchr($inv_email, "@"), 1);
				$bl_result = dbquery("SELECT * FROM ".$db_prefix."blacklist WHERE blacklist_email='".$inv_email."' OR blacklist_email='$email_domain'");
				if (dbrows($bl_result) != 0) {
					$error .= $locale['inv502']."<br />\n";
					$error_free = false;
				}
				// Check if the address is in use
				$sql = "SELECT count(*) as andre FROM ".$db_prefix."users WHERE user_email='".$inv_email."'";
				$data = dbarray(dbquery($sql));
				if ($data['andre'] != "0") {
					$error = $locale['inv503']."<br />\n";
					$error_free = false;
				}
			}
			// Code copied from PHP-Fusion package - START -
				$email_domain = substr(strrchr($inv_email, "@"), 1);
				$bl_result = dbquery("SELECT * FROM ".$db_prefix."blacklist WHERE blacklist_email='".$inv_email."' OR blacklist_email='$email_domain'");
				$blacklisted = dbrows($bl_result);
				if ($blacklisted != 0) $blacklisted = true;
			// Code copied from PHP-Fusion package - END -		
				
			if (!$error_free) {
				opentable($locale['inv200']);
					printInviteForm($inv_email, $error);
				closetable();
				tablebreak();		
			} else {
				debugLine("### email error-free");
				// REMOVE PREVIOUS INVITATIONS
				deleteInvitation("", $inv_email);
	
				// INSERT NEW INVITATION
				$url = addInvitation($inv_email, $userdata['user_id']);
				
				// USER FEEDBACK
				opentable($locale['inv300']);	
					echo "<center>";
					echo $locale['inv301']."\"".$inv_email."\"".$locale['inv302']."<br />\n";
					echo $locale['inv303']."<a href=\"".$url."\">".$locale['inv304']."</a>".$locale['inv305']."<br />\n";
					echo $locale['inv306'].$inv_settings['inv_lasts'].$locale['inv307']."<br />\n";
					echo "</center>";
				closetable();
				tablebreak();		
			}
		} else {
			opentable($locale['inv200']);
				printInviteForm("", "");
			closetable();
			tablebreak();
		}
	} else if(isset($_POST['btnRegister'])) {
		if (!iMEMBER) {
			$username = trim(stripinput($_POST['txtUserName']));
			$pwd1 = trim(stripinput($_POST['txtPwd1']));
			debugLine("pwd: ".$pwd1);
			$pwd2 = trim(stripinput($_POST['txtPwd2']));
			$key = trim(stripinput($_POST['hidKey']));
			$sql = "SELECT * FROM ".$db_prefix."invite_invitations WHERE inv_key='".$key."'";
			$invitation = dbarray(dbquery($sql));
			debugLine("stored invitation email: ".$invitation['inv_email']);
			$error = "";
			$error_free = true;
			// CHECK FOR ERRORS
			if ($username == "") {
				$error = $locale['inv505'];
				$error_free = false;
			} else if ($pwd1 != $pwd2) {
				$error = $locale['inv506'];
				$error_free = false;
			} else if (strlen($pwd1) < 6) {
				$error = $locale['inv507'];
				$error_free = false;
			} else {
				$sql = "SELECT * FROM ".$db_prefix."users WHERE LOWER(user_name)='".strtolower($username)."'";
				$in_use = dbrows(dbquery($sql));
				if ($in_use != 0) {
					$error .= "<br />".$locale['inv624'];
					$error_free = false;
				}
				// aok?
			}
			
			if (!$error_free) {
				opentable($locale['inv600']);
					printRegisterForm($key, $username, $error);
				closetable();
				tablebreak();
			} else {
				debugLine("### registration error-free - ".$pwd1." - ".$pwd2);
			
				// $inv_settings CHECK STUFF ### TODO
				$verify = $settings['email_verification'];
				if ($verify == "1") {
					debugLine("### Email verification needed");
					if ($inv_settings['inv_emailverification'] == "0") {
						debugLine("### email verification overrided by infusion");
						$verify = "0";
					}
				} else {
					$verify = "0";
					debugLine("### Email verification not needed");
					
				}
				
				if ($verify == "1") {
					$email = $invitation['inv_email'];
					require_once INCLUDES."sendmail_include.php";
					mt_srand((double)microtime()*1000000); $salt = "";
					for ($i=0;$i<=7;$i++) { $salt .= chr(rand(97, 122)); }
					$user_code = md5($email.$salt);
					$activation_url = $settings['siteurl']."infusions/invite_infusion/invite.php?activate=".$user_code;
					if (sendemail($username,$email,$settings['siteusername'],$settings['siteemail'],"Welcome to ".$settings['sitename'], $locale['450'].$activation_url)) {
						debugLine("### Email verification sent");
					
						$user_info = serialize(array(
							"user_name" => $username,
							"user_password" => $pwd1,
							"user_email" => $email,
							"user_hide_email" => isNum($_POST['user_hide_email']) ? $_POST['user_hide_email'] : "1"
						));
						$result = dbquery("INSERT INTO ".$db_prefix."new_users (user_code, user_email, user_datestamp, user_info) VALUES('$user_code', '".$email."', '".time()."', '".$user_info."')");
						debugLine("### Insertet into new_users: ".$user_info);
						
						$result = dbquery("DELETE FROM ".$db_prefix."invite_invitations WHERE inv_key='".$key."'");
						debugLine("### Invitation deleted: ".$key);						
						opentable($locale['inv410']);
						echo "<center><br>\n".$locale['inv411']."<br><br>\n</center>\n";
						debugLine("### echo a-411");						
			
						closetable();
						tablebreak();
					} else {
						opentable($locale['inv412']);
						echo "<center><br>\n".$locale['inv413']."<br><br>\n</center>\n";
						debugLine("### echo b-413");						
						closetable();
						tablebreak();
					}
				} else {
					$email = $invitation['inv_email'];
					if($settings['admin_activation'] == "1") {
						debugLine("### admin activation needed");						
					
						$activation = "2";
						if ($inv_settings['inv_adminapproval'] == "0") {
							$activation = "0";
							debugLine("### admin activation overrided by infusion");
						}
					} else {
						$activation = "0";
						debugLine("### admin activation not needed");						
					}
					// CHECKS IF INVITED PERSONS NEED ADMIN APPROVAL
					$result = dbquery("INSERT INTO ".$db_prefix."users (user_name, user_password, user_email, user_hide_email, user_location, user_birthdate, user_aim, user_icq, user_msn, user_yahoo, user_web, user_theme, user_offset, user_avatar, user_sig, user_posts, user_joined, user_lastvisit, user_ip, user_rights, user_groups, user_level, user_status) VALUES('$username', md5('".$pwd1."'), '".$email."', '$user_hide_email', '$user_location', '$user_birthdate', '$user_aim', '$user_icq', '$user_msn', '$user_yahoo', '$user_web', '$user_theme', '$user_offset', '', '$user_sig', '0', '".time()."', '0', '".USER_IP."', '', '', '101', '$activation')");
					debugLine("### inserted into users:<br />'$username', md5('".$pwd1."'), '".$email."', '$user_hide_email', '$user_location', '$user_birthdate', '$user_aim', '$user_icq', '$user_msn', '$user_yahoo', '$user_web', '$user_theme', '$user_offset', '', '$user_sig', '0', '".time()."', '0', '".USER_IP."', '', '', '101', '$activation'");						

					$result = dbquery("DELETE FROM ".$db_prefix."invite_invitations WHERE inv_key='".$key."'");
					debugLine("### deleted invitation: ".$key);						
					opentable($locale['inv410']);
					if ($activation == "2") {
						echo "<center><br>\n".$locale['inv416']."<br><br>\n".$locale['inv414']."<br><br>\n</center>\n";
						debugLine("### echo c-416");						
					} else {
						echo "<center><br>\n".$locale['inv416']."<br><br>\n".$locale['inv415']."<br><br>\n</center>\n";
						debugLine("### echo d-416");						
					}
					closetable();
					tablebreak();
				}
			}
		} else {
			fallback("../../index.php");
		}	
	} else if(isset($_GET['activate'])) {
		$key = trim(stripinput($_GET['activate']));
		// CODE FROM REGISTER.PHP - START
		if (!preg_match("/^[0-9a-z]{32}$/", $key)) fallback("../../index.php");
		$result = dbquery("SELECT * FROM ".$db_prefix."new_users WHERE user_code='".$activate."'");
		if (dbrows($result) != 0) {
			$data = dbarray($result);
			$user_info = unserialize($data['user_info']);
			// OWN CODE... START
			if($settings['admin_activation'] == "1") {
				debugLine("### admin activation needed");						
			
				$activation = "2";
				if ($inv_settings['inv_adminapproval'] == "0") {
					$activation = "0";
					debugLine("### admin activation overrided by infusion");
				}
			} else {
				$activation = "0";
				debugLine("### admin activation not needed");						
			}
			// OWN CODE... END

			$result = dbquery("INSERT INTO ".$db_prefix."users (user_name, user_password, user_email, user_hide_email, user_location, user_birthdate, user_aim, user_icq, user_msn, user_yahoo, user_web, user_theme, user_offset, user_avatar, user_sig, user_posts, user_joined, user_lastvisit, user_ip, user_rights, user_groups, user_level, user_status) VALUES('".$user_info['user_name']."', '".md5($user_info['user_password'])."', '".$user_info['user_email']."', '".$user_info['user_hide_email']."', '', '0000-00-00', '', '', '', '', '', 'Default', '0', '', '', '0', '".time()."', '0', '".USER_IP."', '', '', '101', '".$activation."')");
			debugLine("### inserted into users:<br />'$username', md5('".$pwd1."'), '".$email."', '$user_hide_email', '$user_location', '$user_birthdate', '$user_aim', '$user_icq', '$user_msn', '$user_yahoo', '$user_web', '$user_theme', '$user_offset', '', '$user_sig', '0', '".time()."', '0', '".USER_IP."', '', '', '101', '$activation'");						

			$result = dbquery("DELETE FROM ".$db_prefix."new_users WHERE user_code='".$activation."'");	
			debugLine("### deleted invitation: ".$key);						

			opentable($locale['inv416']);
			if ($activation == "0") {
				echo "<center><br>\n".$locale['inv417']."<br><br>\n".$locale['inv415']."<br><br>\n</center>\n";
				debugLine("### echo e-415");
				
			} else {
				echo "<center><br>\n".$locale['inv417']."<br><br>\n".$locale['inv414']."<br><br>\n</center>\n";
				debugLine("### echo f-414");
			}
			closetable();
			tablebreak();
			// CODE FROM REGISTER.PHP - END
		} else {
			fallback("../../index.php");
		}
	} else if(isset($_GET['key'])) {
		if(iGUEST) {
			opentable($locale['inv600']);
				$key = trim(stripinput($_GET['key']));
				$sql = "SELECT * FROM ".$db_prefix."invite_invitations WHERE inv_key='".$key."'";
				$result = dbquery($sql);
				$rows = dbrows($result);
				if($rows == 1) {
					printRegisterForm($key, "", "");
				} else {
					debugLine("### echo g-504");
					echo "<center>".$locale['inv504']."</center>";
				}
			closetable();
			tablebreak();
		} else {
			fallback("../../index.php");
		}
	} else {
		fallback("../../index.php");
	}
} else {
	opentable($locale['inv509']);
		echo "<center><br />\n".$locale['inv508']."<br /><br /></center>";
	closetable();
	tablebreak();

}
if ($debugMode) {
	debugOut();
}
require_once BASEDIR."side_right.php";
require_once BASEDIR."footer.php";
?>