<?php
/**
* Page-description: This is the admin panel in the invitation infusion. It allows the administrator to decide who can invite others
* and customize the registration function of the site with invite "overrides". Admin can also delete or resend invitations through this page.
* @package infusion
* @tables dbprefix_invite_invitations, dbprefix_invite_settings
*/
/*---------------------------------------------------+
| PHP-Fusion 6 Content Management System
+----------------------------------------------------+
| Copyright  2002 - 2005 Nick Jones
| http://www.php-fusion.co.uk/
+----------------------------------------------------+
| Released under the terms & conditions of v2 of the
| GNU General Public License. For details refer to
| the included gpl.txt file or visit http://gnu.org
+----------------------------------------------------+
| Invite Infusion made by:
| XtraLars, bigwimp, johanf
+----------------------------------------------------*/
require_once "../../maincore.php";
require_once BASEDIR."subheader.php";
require_once ADMIN."navigation.php";

if (!checkrights("IP")) fallback("../index.php");

// Check if locale file is available matching the current site locale setting.
if (file_exists(INFUSIONS."invite_infusion/locale/".$settings['locale'].".php")) {
	// Load the locale file matching the current site locale setting.
	include INFUSIONS."invite_infusion/locale/".$settings['locale'].".php";
} else {
	// Load the infusion's default locale file.
	include INFUSIONS."invite_infusion/locale/English.php";
}
// INFUSION INCLUDES
define("IN_INVITE", true, true);
require_once INFUSIONS."invite_infusion/toolbox.php"; 
// FUNCTIONS
/**
* Prints a table containing all active invitations
* @name printActiveInvitationList
* @tables dbprefix_invite_invitations
* @global array $locale Array from language-file (locale-file)
* @global string $db_prefix String representing the PHP-Fusion table prefix (ie: "fusion_")
* @author XtraLars <xtralars@baluba.org>
*/
function printActiveInvitationList() {
	global $db_prefix, $locale, $settings, $inv_settings;
	opentable($locale['inv810']);
		$sql = "SELECT * FROM ".$db_prefix."invite_invitations ORDER BY inv_date DESC";
		$result = dbquery($sql);
		$rows = dbrows($result);
		if ($rows != 0) {
			echo "<table width=\"100%\" cellpadding=\"0\" cellspacing=\"1\" class=\"tbl-border\" >\n";
			$altrow = 2;
	
			echo "<tr>"
				." <td class=\"tbl".$altrow."\"><strong>".$locale['inv811']."</strong></td>"
				." <td class=\"tbl".$altrow."\"><strong>".$locale['inv812']."</strong></td>"
				." <td class=\"tbl".$altrow."\"><strong>".$locale['inv813']."</strong></td>"
				." <td class=\"tbl".$altrow."\"><strong>".$locale['inv814']."</strong></td>"
				." <td class=\"tbl".$altrow."\" align=\"right\"><strong>".$locale['inv815']."</strong></td>"
				."</tr>";

			while ($data = dbarray($result)) {
				if ($altrow == 2) {
					$altrow = 1;
				} else {
					$altrow = 2;
				}
				$date = explode("-",$data['inv_date']);
				$expday = (int) $date[2] + (int) $inv_settings['inv_lasts'];
				$expdate = strftime($settings['shortdate'],mktime(0, 0, 0, $date[1], $expday, $date[0]));
				$invdate = strftime($settings['shortdate'], mktime(0, 0, 0, $date[1], $date[2], $date[0]));
				echo "<tr>"
					." <td class=\"tbl".$altrow."\">".$data['inv_email']."</td>"
					." <td class=\"tbl".$altrow."\">".$data['inv_key']."</td>"
					." <td class=\"tbl".$altrow."\">".$invdate."</td>"
					." <td class=\"tbl".$altrow."\">".$expdate."</td>"
					." <td class=\"tbl".$altrow."\" align=\"right\">"
					."   <a href=\"invite_admin.php?action=retry&amp;id=".$data['inv_id']."\">".$locale['inv850']."</a> - "
					."   <a href=\"invite_admin.php?action=delete&amp;id=".$data['inv_id']."\">".$locale['inv851']."</a>"
					."</td>"
					."</tr>";
			}
			echo "</table>";
		} else {
			echo "<center>".$locale['inv870']."</center>";
		}
	closetable();
	tablebreak();	
}
/**
* Prints the an option-element for each registered user group
* @name printGroupSelects
* @param integer [$selected] The option to be selected
* @author PHP-Fusion authors and XtraLars <xtralars@baluba.org>
*/
function printGroupSelects($selected) {
	// Code from forum-administration...
	$post_groups = getusergroups(); 
	$opts = "";
	while(list($key, $user_group) = each($post_groups)){
		if ($user_group['0'] != "0") {
			//echo "<!-- selected = ".$selected.", user_group = ".$user_group['0']." -->";
			$sel = ($selected == $user_group['0'] ? "selected" : "");
			$opts .= "<option value='".$user_group['0']."' ".$sel.">".$user_group['1']."</option>\n";
		}
	}
	echo $opts;
} 
/**
* Prints a table containing the form for setting the infusion settings.
* @name printInviteAdminForm
* @tables dbprefix_invite_settings
* @global array $locale Array from language-file (locale-file)
* @global string $db_prefix String representing the PHP-Fusion table prefix (ie: "fusion_")
* @author XtraLars <xtralars@baluba.org>
*/
function printInviteAdminForm() {
	global $locale, $db_prefix;
	$inv_settings = dbarray(dbquery("SELECT * FROM ".$db_prefix."invite_settings"));	
	opentable($locale['inv800']);
	echo "<form action=\"invite_admin.php\" name=\"invAdminForm\" method=\"post\">";
	echo "<center><table width=\"550\" cellpadding=\"1\" cellspacing=\"0\">";
	echo "<tr><td>".$locale['inv820']."</td><td><select name=\"lstEnable\" class=\"textbox\" style=\"width:120px\">";
	if ($inv_settings['inv_enabled'] == "1") {
		echo " <option selected value=\"1\">".$locale['inv804']."</option><option value=\"0\">".$locale['inv805']."</option>";
	} else {
		echo " <option value=\"1\">".$locale['inv804']."</option><option selected value=\"0\">".$locale['inv805']."</option>";
	}
	echo "</select></td></tr>";

	echo "<tr><td>".$locale['inv821']."</td><td><select name=\"lstEmailVer\" class=\"textbox\" style=\"width:120px\">";
	if ($inv_settings['inv_emailverification'] == "1") {
		echo " <option selected value=\"1\">".$locale['inv804']."</option><option value=\"0\">".$locale['inv805']."</option>";
	} else {
		echo " <option value=\"1\">".$locale['inv804']."</option><option selected value=\"0\">".$locale['inv805']."</option>";
	}
    echo "</select></td></tr>";
	
	echo "<tr><td>".$locale['inv822']."</td><td><select name=\"lstAdminVer\" class=\"textbox\" style=\"width:120px\">";
	if ($inv_settings['inv_adminapproval'] == "1") {
		echo " <option selected value=\"1\">".$locale['inv804']."</option><option value=\"0\">".$locale['inv805']."</option>";
	} else {
		echo " <option value=\"1\">".$locale['inv804']."</option><option selected value=\"0\">".$locale['inv805']."</option>";
	}
    echo "</select></td></tr>";
	echo "<tr>";
	
    echo "<td>".$locale['inv823']."</td>";
    echo "<td><select name=\"lstGroupAccess\" class=\"textbox\" style=\"width:120px\">";
	printGroupSelects($inv_settings['inv_group']);
	echo "</select></td></tr>";
	echo "<tr><td>".$locale['inv824']."</td><td><input name=\"txtLasts\" type=\"text\" value=\"".$inv_settings['inv_lasts']."\" style=\"width:120px\" maxlength=\"3\" class=\"textbox\">".$locale['inv825']."</td></tr>";
	echo "<tr><td colspan=\"2\" align=\"center\"><input type=\"submit\" name=\"btnAdminSubmit\" value=\"".$locale['inv806']."\" class=\"button\"></td></tr>";
	echo "</table></center>";
	echo $locale['inv830'];
	echo "</form>";
  	closetable();
	tablebreak();
}
// START
$inv_settings = dbarray(dbquery("SELECT * FROM ".$db_prefix."invite_settings"));
deleteOldInvitations();
if (isset($_GET['action'])) {
	$action = trim(stripinput($_GET['action']));
	switch($action) {
		case "delete":
			// Delete invitation
			$iid = (isNum($_GET['id']) ? (int) $_GET['id'] : -1);
			$sql = "SELECT * FROM ".$db_prefix."invite_invitations where inv_id=".$iid;
			if ($iid != -1 && (dbrows(dbquery($sql)) > 0)) {
				$sql = "SELECT inv_email from ".$db_prefix."invite_invitations where inv_id=".$iid;
				$email = dbarray(dbquery($sql));
				$email = $email['inv_email'];
				deleteInvitation($iid, "");
				opentable($locale['inv860']);
					echo "<center>".$locale['inv862'].$email.$locale['inv863']."</center>";
				closetable();
				tablebreak();
			} else {
				opentable($locale['inv866']);
					echo "<center>".$locale['inv867'].$iid.$locale['inv868']."</center>";
				closetable();
				tablebreak();
				
			}
			break;
		case "retry":
			$iid = (isNum($_GET['id']) ? (int) $_GET['id'] : -1);
			$sql = "SELECT * FROM ".$db_prefix."invite_invitations where inv_id=".$iid;
			$result = dbquery($sql);
			if ($iid != -1 && (dbrows($result) > 0)) {
				$data = dbarray($result);
				$newid = retryInvitation($iid);
				if ($newid != -1) {
					$sql = "SELECT * FROM ".$db_prefix."invite_invitations where inv_id=".$newid;
					$data = dbarray(dbquery($sql));

					opentable($locale['inv866']);
						echo "<center>".$locale['inv864'].$newid.$locale['inv865']."</center>";
					closetable();
					tablebreak();
				} else {
					opentable($locale['inv866']);
						echo "<center>".$locale['inv867'].$iid.$locale['inv868']."</center>";
					closetable();
					tablebreak();
				}
			} else {
				opentable($locale['inv866']);
					echo "<center>".$locale['inv867'].$iid.$locale['inv868']."</center>";
				closetable();
				tablebreak();
				
			}
			break;
		default:
			break;
	}
	printInviteAdminForm();
	printActiveInvitationList();
} else if (isset($_POST['btnAdminSubmit'])) {
	$enabled = (isNum($_POST['lstEnable']) ? (int) $_POST['lstEnable'] : 0);
	$admin_approval = (isNum($_POST['lstAdminVer']) ? (int) $_POST['lstAdminVer'] : 0);
	$email_verification = (isNum($_POST['lstEmailVer']) ? (int) $_POST['lstEmailVer'] : 0);
	$invite_group = (isNum($_POST['lstGroupAccess']) ? (int) $_POST['lstGroupAccess'] : 101);
	$lasts = (isNum($_POST['txtLasts']) ? (int) $_POST['txtLasts'] : 10);
	if ($lasts < 1) { $lasts = 1; }
	$sql = "UPDATE ".$db_prefix."invite_settings SET inv_enabled=".$enabled.", inv_adminapproval=".$admin_approval.","
		." inv_emailverification=".$email_verification.", inv_lasts=".$lasts.", inv_group=".$invite_group;
	$result = dbquery($sql);
	$inv_settings = dbarray(dbquery("SELECT * FROM ".$db_prefix."invite_settings"));
	printInviteAdminForm();
	printActiveInvitationList();
} else {
	printInviteAdminForm();
	printActiveInvitationList();
}
require_once BASEDIR."footer.php";
?>