<?php
/***************************************************************************
 *   awEventCalendar                                                       *
 *                                                                         *
 *   Copyright (C) 2006-2007 Artur Wiebe                                   *
 *   wibix@gmx.de                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
require_once("../../maincore.php");
require_once(BASEDIR."subheader.php");
require_once(BASEDIR."side_left.php");

require_once("include/common.php");

if(isset($_GET['view']) && $_GET['view']=="list") {
	$view = "list";
} else {
	$view = "cal";
}


/*
 * birthday
 */
if(ec_check_access($ec_settings['show_birthday_to_group'])) {
	opentable(str_replace("%s", $locale['EC900'][$ec_month], $locale['EC401']));

	$query_id = dbquery("SELECT user_name,"
		." DATE_FORMAT(user_birthdate, '".$ec_settings['birthdate_fmt']."') AS birthday,"
		." user_id, user_avatar"
		." FROM ".DB_PREFIX."users"
		." WHERE MONTH(user_birthdate)='$ec_month'"
		." ORDER BY DAYOFMONTH(user_birthdate) ASC");
	if(!dbrows($query_id)) {
		echo "<p>".$locale['EC004'];
	} else {
		echo "<ul>\n";
	}
	while($user = dbarray($query_id)) {
/*		if($user['user_avatar']!="") {
				echo "<img src='".BASEDIR."images/avatars/"
				.$user['user_avatar']."'><br/>";
		}
*/
		echo "<li>".$user['birthday']
//			.showdate("%x", $user['birthday'])
			." <a href='".BASEDIR."profile.php?lookup=".$user['user_id']
			."'>".$user['user_name']."</a></li>\n";
	}
	if(dbrows($query_id)) {
		echo "</ul>\n";
	}

	closetable();
	tablebreak();
}



/*
 * GUI
 */


// create cal-navigation
$pyear = $ec_year;
$nyear = $ec_year;
$pmonth = $ec_month-1;
$nmonth = $ec_month+1;
if($pmonth<1) {
	$pmonth = 12;
	$pyear = $ec_year-1;
} elseif($nmonth>12) {
	$nmonth = 1;
	$nyear = $ec_year+1;
}

$sel_months = "";
for($i=1; $i<=12; ++$i) {
	$sel_months .= "<option value='$i'".($i==$ec_month ? " selected" : "").">"
		.$locale['EC900'][$i]."</option>\n";
}
$cal_navi = "\n<form method='get' action='".FUSION_SELF."'>
<input type='hidden' name='view' value='$view'>
<a href='".FUSION_SELF."?y=$pyear&amp;m=$pmonth'><img src='".THEME
	."images/left.gif' alt='&lt;' border='0'></a>
<select class='textbox' name='m'>$sel_months</select>
<a href='".FUSION_SELF."?y=$nyear&amp;m=$nmonth'><img src='".THEME
	."images/right.gif' alt='&gt;' border='0'></a>
<input type='text' size='4' maxlength='4' class='textbox' name='y' value='$ec_year'>
<input type='submit' value='".$locale['EC451']."' class='button'>
</form>";


/*
 * GUI - month overview
 */
opentable($locale['EC400']);
echo ec_get_menu();
echo "<table border='0' cellspacing='0' cellpadding='0' width='100%'>
<tr>
	<td align='left' width='1%'><a href='".FUSION_SELF."?view=$view'>"
		.$locale['EC201']."</a></td>
	<td align='center'>$cal_navi</td>
	<td align='right' width='1%' style='white-space:nowrap;'><b>"
		.$locale['EC402'].":</b> "
		."<a href='".FUSION_SELF."?y=$ec_year&amp;m=$ec_month'>"				//flyingduck added &amp; instead of &
			.$locale['EC403']."</a>"
		." | <a href='".FUSION_SELF."?y=$ec_year&amp;m=$ec_month&amp;view=list'>"		//flyingduck added &amp; instead of &
			.$locale['EC404']."</a></td>
</tr>
</table>
<hr>\n";

$events = ec_get_events("", $ec_month, $ec_year, "day", false);
$bullet = "<img src='".THEME."images/bullet.gif' alt='-' border='0'>";

$content = array();
for($i=1; $i<=31; ++$i) {
	if($view=="list") {
		$content[$i] = "&nbsp;";
	} else {
		$content[$i] = array(
			"style"	=> "awec_empty",
			"data"	=> "$i.",
		);
	}
}
foreach($events as $day => $more) {
	$btext = "";
	foreach($more as $ev_id => $day_data) {
		$title = $day_data['ev_title'];
		$btext .= $bullet." <a href='view_event.php?id=$ev_id'"
			." title='$title'>$title</a><br>\n";
	}
	if($view=="list") {
		$content[$day] = $btext;
	} else {
		$content[$day] = array(
			"style"	=> "awec_content",
			"data"	=> "<div style='overflow:hidden;'>"
				."<a href='day.php?y=$ec_year&amp;m=$ec_month"
					."&amp;d=$day'>$day.</a><br>"
				.$btext
				."</div>",
		);
	}
}
if($ec_is_this_month && $view!="list") {
	$content[$ec_today['mday']]['style'] = "awec_current";
}

if($view=="list") {
	$this_month = mktime(0, 0, 0, $ec_month, 1, $ec_year);
	$daysinmonth = date("t", $this_month);
	echo "<table width='100%' class='tbl-border' cellspacing='1'>\n";
	for($i=1; $i<=$daysinmonth; ++$i) {
		if($ec_is_this_month && $ec_today['mday']==$i) {
			$tbl = "awec_current";
		} else {
			$tbl = "tbl".($i%2 + 1);
		}
		echo "<tr>
	<td class='$tbl' width='1%' align='right' valign='top'>"
		."<a href='day.php?y=$ec_year&amp;m=$ec_month&amp;d=$i'>"
		."$i</a>.</td>
	<td class='$tbl'>".$content[$i]."</td>
</tr>\n";
	}
	echo "</table>\n";
} else {
	ec_render_cal($ec_month, $ec_year, "", $content,
		"left", "top", 80, true);
}

closetable();


require_once BASEDIR."side_right.php";
require_once BASEDIR."footer.php";
?>
