<?php
/***************************************************************************
 *   awEventCalendar                                                       *
 *                                                                         *
 *   Copyright (C) 2006-2007 Artur Wiebe                                   *
 *   wibix@gmx.de                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
require_once("../../maincore.php");
require_once(BASEDIR."subheader.php");
require_once(BASEDIR."side_left.php");

require_once("include/common.php");

if(isset($_GET['stext'])) {
	$swords = preg_split("/\s+/", trim(stripinput($_GET['stext'])));
	$stext = trim(stripinput($_GET['stext']));
	// verify not too short
	$to_short = false;
	foreach($swords as $val) {
		if(strlen($val) < 3) {
			$to_short = true;
			break;
		}
	}
	if($to_short) {
		$swords = array();
//		unset($stext);
	}
} else {
	$swords = array();
	unset($stext);
}

$no_l = "checked";
$and_l = "";
$or_l = "";
if(isset($_GET['link'])) {
	if($_GET['link']=="AND") {
		$link = "AND";
		$no_l = "";
		$and_l = "checked";
		$or_l = "";
	} elseif($_GET['link']=="OR") {
		$link = "OR";
		$no_l = "";
		$and_l = "";
		$or_l = "checked";
	} else {
		$link = "";
	}
} else {
	$link = "";
}


/*
 * GUI
 */
opentable($locale['EC011']);
echo ec_get_menu();

$st = (isset($stext) ? $stext : "");

echo "<form method='get' action='".FUSION_SELF."'>
<table border='0'>
<tr>
	<td>".$locale['EC550'].":</td>
	<td><input type='text' name='stext' class='textbox' value='$st'></td>
</tr>
<tr>
	<td valign='top'>".$locale['EC553'].":</td>
	<td><input type='radio' name='link' value='' $no_l>"
		.$locale['EC551']['-']."<br>"
		."<input type='radio' name='link' value='AND' $and_l>"
			.$locale['EC551']['AND']."<br>"
		."<input type='radio' name='link' value='OR' $or_l>"
			.$locale['EC551']['OR']."</td>
<tr>
	<td></td>
	<td><input type='submit' class='button' value='".$locale['EC011']."'></td>
</tr>
</table>
</form>\n";


if(count($swords)) {
	echo "<p><b>".$locale['EC550'].":</b> "
		.(empty($link)
			? $stext
			: implode(" ".$locale['EC551'][$link]." ", $swords));

	if(empty($link)) {
		$search_string = "ev_title LIKE '%$stext%'"
			." OR ev_body LIKE '%$stext%'";
	} else {
		$search_string = array();
		foreach($swords as $word) {
			$search_string[] = "ev_title LIKE '%$word%'"
				." OR ev_body LIKE '%$word%'";
		}
		$search_string = implode(" $link ", $search_string);
	}

	// access - edit group - no access limit
	if(iADMIN) {
		$access = "";
	} elseif(iMEMBER) {
		$access = " AND (((ev_status='0' AND ev_private='0')"
			." OR user_id='".$userdata['user_id']."')"
			." AND ".groupaccess("ev_access").")";
	} else {
		$access = " AND ((ev_status='0' AND ev_private='0')"
			." AND ev_access='0')";
	}

	$query_id = dbquery("SELECT DAYOFMONTH(ev_start) AS day,"
		." ev_title, ev_id, ev_access, YEAR(ev_start) AS year,"
		." MONTH(ev_start) AS month"
		." FROM ".DB_PREFIX."aw_ec_events"
		." WHERE $search_string $access"
		." ORDER BY DAYOFMONTH(ev_start) ASC");
	echo "<p>".dbrows($query_id)." ".$locale['EC552']."<ul>";
	while($ev = dbarray($query_id)) {
		echo "<li><a href='view_event.php?id=".$ev['ev_id']."'>"
			.$ev['ev_title']."</a></li>\n";
	}
	echo "</ul>\n";
} else {
	if(isset($stext)) {
		echo "<p><strong>".$locale['EC554']."</strong>";
	}
}
closetable();


require_once BASEDIR."side_right.php";
require_once BASEDIR."footer.php";
?>
