<?php
/***************************************************************************
 *   awEventCalendar                                                       *
 *                                                                         *
 *   Copyright (C) 2006-2007 Artur Wiebe                                   *
 *   wibix@gmx.de                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
require_once("../../maincore.php");
require_once(BASEDIR."subheader.php");
require_once(BASEDIR."side_left.php");

if(!iMEMBER) {
	fallback("calendar.php");
}

require_once("include/common.php");

if(!iEC_ADMIN && !ec_check_access($ec_settings['post_group'])) {
	fallback("calendar.php");
}


if(isset($_GET['id']) && isNum($_GET['id'])) {
	$id = $_GET['id'];
} else {
	unset($id);
}

if(iEC_ADMIN) {
	$user_access = "";
} else {
	$user_access = "AND user_id='".$userdata['user_id']."'";
}

$title = "";
$access = 0;
$body = "";
$disable_smilies = 1;
$ev_start = getdate(time());
//
$allow_logins = 0;
$max_logins = 0;
$login_access = 101;
//
$ev_repeat = 0;
$is_private = 0;

$errors = 0;
if(isset($_GET['errno']) && isNum($_GET['errno'])) {
	$errno = $_GET['errno'];
} else {
	unset($errno);
}


/*
 * ACTION
 */
if(isset($_POST['save'])) {
	$title = trim(stripinput($_POST['title']));
	$body = trim(stripinput($_POST['desc']));
	if(empty($title) || empty($body)) {
		$errors++;
	}
	$access = $_POST['access']+0;
	$disable_smilies = (isset($_POST['disable_smileys']) ? "1" : "0");
	$ev_start = array(
		"year"		=> $_POST['start_year']+0,
		"mon"		=> $_POST['start_month']+0,
		"mday"		=> $_POST['start_mday']+0,
		"hours"		=> $_POST['start_hours']+0,
		"minutes"	=> $_POST['start_mins']+0,
	);
	$start = $ev_start['year']."-".$ev_start['mon']
		."-".$ev_start['mday']
		." ".$ev_start['hours'].":".$ev_start['minutes'].":00";
	$end = $start; 	// "0000-00-00 00:00:00";	// FIXME

	$allow_logins = (isset($_POST['allow_logins']) ? "1" : "0");
	$max_logins = $_POST['max_logins']+0;
	$login_access = $_POST['login_access']+0;
	if(!$login_access || !ec_check_access($login_access)) {
		$login_access = 101;
	}

	$ev_repeat = $_POST['repeat']+0;
	$is_private = (isset($_POST['is_private']) ? "1" : "0");

	$now = time();
	if($is_private || iEC_ADMIN) {
		$status = "0";
	} else {
		$status = ($ec_settings['need_admin_ok'] ? "1" : "0");
	}


	if($is_private) {
		if($allow_logins) {
			$allow_logins = "0";
			$max_logins = "0";
			$login_access = "101";
			$errno = EC_ELOGIN;
		}
		if($access) {
			$access = "0";
			$errno = EC_EACCESS;
		}
	}

	if($errors==0) {
		if(!isset($id)) {
			$query_id = dbquery("INSERT INTO ".DB_PREFIX."aw_ec_events"
				." SET"
				." user_id='".$userdata['user_id']."',"
				." ev_timestamp='$now',"
				." ev_body=''");
			$id = mysql_insert_id();
		}

		$ok = dbquery("UPDATE ".DB_PREFIX."aw_ec_events"
			." SET"
			." ev_title='$title', ev_body='$body',"
			." ev_start='$start',"
			." ev_end='$end',"
			." ev_repeat='$ev_repeat',"
			." ev_private='$is_private',"
			." ev_status='$status',"
			." ev_no_smileys='$disable_smilies',"
			." ev_allow_logins='$allow_logins',"
			." ev_max_logins='$max_logins',"
			." ev_access='$access',"
			." ev_login_access='$login_access'"
			." WHERE ev_id='$id' $user_access");
		if(!$ok) {
			$errno = EC_EDB;
		}
		if(!isset($errno)) {
			fallback("edit_event.php?id=$id&errno=0");
		}
	}

} elseif(isset($_GET['del']) && isset($id)) {
	$ok = dbquery("DELETE FROM ".DB_PREFIX."aw_ec_events"
		." WHERE ev_id='$id' $user_access");
	if($ok) {
		$ok = dbquery("DELETE FROM ".DB_PREFIX."aw_ec_logins"
			." WHERE ev_id='$id'");
	}
	if($ok) {
		if(isset($_GET['back_to'])) {
			fallback("new_events.php");
		} else {
			fallback("calendar.php");
		}
	}

} elseif(isset($_GET['status']) && isset($id) && isset($_GET['time'])
	&& isNum($_GET['time']) && iEC_ADMIN) {
	$ok = dbquery("UPDATE ".DB_PREFIX."aw_ec_events"
		." SET ev_status=MOD(ev_status+1, 2)"
		." WHERE ev_id='$id' AND ev_timestamp='".$_GET['time']."'");
	if($ok) {
		if(isset($_GET['back_to'])) {
			fallback("new_events.php");
		} else {
			fallback("edit_event.php?id=$id");
		}
	}
}



/*
 * GET
 */
if(isset($id)) {
	$query_id = dbquery("SELECT * FROM ".DB_PREFIX."aw_ec_events"
		." WHERE ev_id='$id' $user_access");
	if(!dbrows($query_id)) {
		fallback("calendar.php");
	}
	$event = dbarray($query_id);
	$title = $event['ev_title'];
	$body = $event['ev_body'];
	$ev_repeat = $event['ev_repeat'];
	$is_private = $event['ev_private'];
	$allow_logins = $event['ev_allow_logins'];
	$max_logins = $event['ev_max_logins'];
	$disable_smilies = $event['ev_no_smileys'];
	$access = $event['ev_access'];
	//
	$ev_start = array(
		"year"		=> substr($event['ev_start'], 0, 4),
		"mon"		=> substr($event['ev_start'], 5, 2),
		"mday"		=> substr($event['ev_start'], 8, 2),
		"hours"		=> substr($event['ev_start'], 11, 2),
		"minutes"	=> substr($event['ev_start'], 14, 2),
	);
	$end = $ev_start;
	//
	$login_access = $event['ev_login_access'];
} else {
	$event = array(
		"ev_status"	=> "0",
	);
}


function ec_make_select($date, $fname) {
	global $locale;

	$date['mday'] = str_pad($date['mday'], 2, "0", STR_PAD_LEFT);
	$date['mon'] = str_pad($date['mon'], 2, "0", STR_PAD_LEFT);
	$date['hours'] = str_pad($date['hours'], 2, "0", STR_PAD_LEFT);
	$date['minutes'] = str_pad($date['minutes'], 2, "0", STR_PAD_LEFT);

	$sel_day = "";
	$sel_month = "";
	$sel_mins = "";
	$sel_hours = "";

	// day
	for($i=1; $i<=31; ++$i) {
		$sel_day .= "<option value='$i'"
			.($i==$date['mday'] ? " selected" : "").">"
			.$i."</option>\n";
	}
	// month
	for($i=1; $i<=12; ++$i) {
		$sel_month .= "<option value='$i'"
			.($i==$date['mon'] ? " selected" : "").">"
			.$locale['EC900'][$i]."</option>\n";
	}
	// hours
	for($i=0; $i<=23; ++$i) {
		$sel_hours .= "<option value='$i'"
			.($i==$date['hours'] ? " selected" : "").">"
			.$i."</option>\n";
	}
	// mins
	for($i=0; $i<=59; ++$i) {
		$sel_mins .= "<option value='$i'"
			.($i==$date['minutes'] ? " selected" : "").">"
			.$i."</option>\n";
	}

	return "<select class='textbox' name='${fname}_mday'>"
			.$sel_day."</select>"
		.".<select class='textbox' name='${fname}_month'>"
			.$sel_month."</select>"
		.".<input type='text' class='textbox' name='${fname}_year'"
			." value='".$date['year']."' size='5' maxlength='4'>"
		." / "
		." <select class='textbox' name='${fname}_hours'>"
			.$sel_hours."</select>"
		.":<select class='textbox' name='${fname}_mins'>"
			.$sel_mins."</select>\n";
}


function ec_get_timestamp($fname) {
	return mktime($_POST[$fname."_hours"], $_POST[$fname."_mins"], 0,
		$_POST[$fname."_month"], $_POST[$fname."_mday"],
		$_POST[$fname."_year"]);
}



/*
 * GUI
 */
$sel_access = "";
$sel_login_access = "";
$fusion_groups = getusergroups();
foreach($fusion_groups as $group) {
	list($gid, $gname) = $group;
	if(!ec_check_access($gid)) {
		continue;
	}

	$sel_access .= "<option value='$gid'"
		.($gid==$access ? " selected" : "").">"
		.$gname."</option>\n";

	if(!$gid) {
		continue;
	}
	$sel_login_access .= "<option value='$gid'"
		.($gid==$login_access ? " selected" : "").">"
		.$gname."</option>\n";
}

$sel_repeat = "";
foreach($locale['EC125'] as $rep => $text) {
	$sel_repeat .= "<option value='$rep'"
		.($ev_repeat==$rep ? " selected" : "").">"
		."$text</option>\n";
}



/*
 * GUI
- <input type='button' value='".EC_BREAK."' class='button' onClick=\"insertText('comment_message', '".EC_BREAK."');\">\n";
 */
opentable(isset($id) ? $locale['EC101'] : $locale['EC100']);
echo ec_get_menu();

$action = FUSION_SELF;
if(isset($id)) {
	$action .= "?id=$id";
	echo "<div align='right'><a href='view_event.php?id=$id'>"
		.$locale['EC102']."</a>\n";
	if(iADMIN) {
		echo " | <a href='$action&amp;status=1'>".($event['ev_status']
			? $locale['EC306']
			: $locale['EC307'])
		."</a>\n";
	}
	echo "</div>\n";
}


if($errors) {
	echo "<p><div style='text-align:center;'><strong>"
		.$locale['EC119']."</strong></div></p>\n";
}
if(isset($errno) && isset($locale['EC113'][$errno])) {
	echo "<p><div style='text-align:center;'><strong>"
		.$locale['EC113'][$errno]."</strong></div></p>\n";
}


if($event['ev_status']) {
	$status = "<tr>
	<td class='forum-caption' height='50' colspan='2' align='center' valign='center'>"
		.$locale['EC113'][EC_ESTATUS]."</td>
</tr>\n";
} else {
	$status = "";
}



echo "<p><span class='small2'>".$locale['EC118']."</span>
<form action='$action' method='post' name='inputform'>
<table width='100%' class='tbl-border' cellspacing='1'>
$status
<tr>
	<td class='tbl2' width='150'>".$locale['EC103'].": *</td>
	<td class='tbl1'><input value='$title' type='text'"
		." name='title' class='textbox' style='width:100%;'></td>
</tr>
<tr>
	<td class='tbl2'>".$locale['EC116'].":</td>
	<td class='tbl1'><select class='textbox' name='access'>"
		."$sel_access</select></td>
</tr>
<tr>
	<td class='tbl2' valign='top'>".$locale['EC104'].": *</td>
	<td class='tbl1'><textarea name='desc' rows='8'"
		." class='textbox' style='width:100%;'>".$body
		."</textarea><br>"
		.ec_get_bb_smileys("desc", true, $disable_smilies)."</td>
</tr>
<tr>
	<td class='tbl2'>".$locale['EC105'].":</td>
	<td class='tbl1'>".ec_make_select($ev_start, "start")
		."<br><span class='small2'>".$locale['EC120']."</span></td>
</tr>
<!-- logins -->
<tr>
	<td class='forum-caption' colspan='2'><input type='checkbox'"
		." name='allow_logins'".($allow_logins ? " checked" : "")
		."> ".$locale['EC109']."</td>
</tr>
<tr>
	<td class='tbl2'>".$locale['EC110'].":</td>
	<td class='tbl1'><input type='text' class='textbox' name='max_logins'"
		." value='$max_logins' size='5' maxlength='5'>"
		." <span class='small2'>".$locale['EC110_1']."</span></td>
</tr>
<tr>
	<td class='tbl2'>".$locale['EC116'].":</td>
	<td class='tbl2'><select name='login_access' class='textbox'>$sel_login_access</select></td>
</tr>
<!-- misc -->
<tr>
	<td class='forum-caption' colspan='2'>".$locale['EC122']."</td>
</tr>
<tr>
	<td class='tbl2'>".$locale['EC107'].":</td>
	<td class='tbl1'><select class='textbox' name='repeat'>"
		."$sel_repeat</select></td>
</tr>
<tr>
	<td class='tbl2' valign='top'>".$locale['EC106'].":</td>
	<td class='tbl1'><input type='checkbox' name='is_private'"
		.($is_private ? " checked" : "").">".$locale['EC108']."</td>
</tr>
<tr>
	<td class='tbl2' colspan='2' align='center'>"
		."<input type='submit' name='save' class='button'"
			." value='".$locale['EC111']."'></td>
</tr>
</table>
</form>";
closetable();


require_once(BASEDIR."side_right.php");
require_once(BASEDIR."footer.php");
?>
