<?php
/***************************************************************************
 *   awEventCalendar                                                       *
 *                                                                         *
 *   Copyright (C) 2006-2007 Artur Wiebe                                   *
 *   wibix@gmx.de                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
if(!defined("IN_FUSION")) {
	header("Location:../../index.php");
	exit;
}

require_once(INFUSIONS."aw_ecal_panel/include/common.php");


?>
<!--<body onLoad='setBallon("BallonTip");'>-->
<div id="BallonTip"
	style="position:absolute; visibility:hidden; left:-200px; z-index: 100">
</div>
<?php

if(isset($body_text)) {
	$body_text = descript($body_text);
} else {
	$body_text = $ec_settings['ballon_fg'];
}
if(isset($body_bg)) {
	$body_bg = descript($body_bg);
} else {
	$body_bg = $ec_settings['ballon_bg'];
}

echo "
<script type='text/javascript' src='"
	.INFUSIONS."aw_ecal_panel/cross.js'></script>
<script type='text/javascript' src='"
	.INFUSIONS."aw_ecal_panel/tooltips.js'></script>";
echo "<script type='text/javascript'>
	setBallon(\"BallonTip\", \"".$ec_settings['ballon_w']."\","
		." \"$body_text\", \"$body_bg\");
</script>\n";


$bullet = "<img src=\"".THEME."images/bullet.gif\" alt=\"-\" border=\"0\">";
$today_events = array();
$tomorrow_events = array();


/*
 * GUI
 */
openside($locale['EC001']);

$events = ec_get_events("", $ec_month, $ec_year, "day", false);
$content = array();
for($i=1; $i<=31; ++$i) {
	$content[$i] = array(
		"style"	=> "awec_empty",
		"data"	=> $i,
	);
}
foreach($events as $day => $more) {
	$btext = "";
	foreach($more as $ev_id => $day_data) {
		$title = $day_data['ev_title'];
		$btext .= $bullet." $title<br>";
		if($ec_is_this_month) {
			if($ec_today['mday']==$day) {
				$today_events[$ev_id] = $title;
			} elseif(($ec_today['mday']+1)==$day) {
				$tomorrow_events[$ev_id] = $title;
			}
		}
	}
	$btext = phpentities($btext);
	$btitle = phpentities("<b>$day. ".$locale['EC900'][$ec_month]."</b>");
	$content[$day] = array(
		"style"	=> "awec_content",
		"data"	=> "<a href='".INFUSIONS."aw_ecal_panel/day.php"
			."?y=$ec_year&amp;m=$ec_month&amp;d=$day'"
			." onMouseOver=\"return showBallon('$btitle', '$btext');\""
			." onMouseOut='return hideBallon();'>$day</a>",
	);
}
if($ec_is_this_month) {
	$content[$ec_today['mday']]['style'] = "awec_current";
}


$pyear = $ec_year;
$nyear = $ec_year;
$pmonth = $ec_month-1;
$nmonth = $ec_month+1;
if($pmonth<1) {
	$pmonth = 12;
	$pyear = $ec_year-1;
} elseif($nmonth>12) {
	$nmonth = 1;
	$nyear = $ec_year+1;
}

$path = INFUSIONS."aw_ecal_panel";

$href = FUSION_SELF;
unset($_GET['y']);
unset($_GET['m']);
$gets = array();
foreach($_GET as $key => $val) {
	$gets[] = "$key=$val";
}

$href = FUSION_SELF."?".(count($gets) ? implode("&amp;", $gets)."&amp;" : "");
$title = "
<a href='".$href."y=$pyear&amp;m=$pmonth'><img src='".THEME
	."images/left.gif' alt='&lt;' border='0'></a>
<a href='$path/calendar.php?y=$ec_year&amp;m=$ec_month'>"
	.$locale['EC900'][$ec_month]." $ec_year</a>
<a href='".$href."y=$nyear&amp;m=$nmonth'><img src='".THEME
	."images/right.gif' alt='&gt;' border='0'></a>\n";
ec_render_cal($ec_month, $ec_year, $title, $content,
	"right", "bottom", 0, false);


/*
 *
 */
if(iMEMBER) {
	if(iEC_ADMIN || ec_check_access($ec_settings['post_group'])) {
		echo $bullet." <a href='$path/edit_event.php' class='side'>"
			.$locale['EC200']."</a><br>\n";
	}
	echo $bullet." <a href='$path/my_events.php' class='side'>"
		.$locale['EC204']."</a><br>\n";
	echo $bullet." <a href='$path/my_logins.php' class='side'>"
		.$locale['EC206']."</a><br>\n";
	if(iSUPERADMIN) {
		echo $bullet." <a href='$path/admin.php' class='side'>"
			.$locale['EC700']."</a><br>\n";
	}
}



if(iEC_ADMIN) {
	if(dbcount("(*)", "aw_ec_events", "(ev_status!='0')")) {
		echo "<p><div align='center'><b><a href='$path/new_events.php'"
			." class='side'>".$locale['EC203']."</a></b></div>\n";
	}
}


if(count($today_events)) {
	echo "<p><b>".$locale['EC201'].":</b><br>\n";
	foreach($today_events as $id => $title) {
		$body = "";
		if($ec_settings['show_today_in_panel']) {
			$body = array_shift(dbarray(dbquery("SELECT ev_body"
				." FROM ".DB_PREFIX."aw_ec_events"
				." WHERE ev_id='$id'")))
				."<br>";
		}
		$body = parseubb($body);
		$body = explode(EC_BREAK, $body);
		if(count($body)>1) {
			$body[0] .= " <a href='$path/view_event.php?id=$id'"
				." class='side'>"
				.$locale['EC207']."</a>";
		}

		echo $bullet." <a href='$path/view_event.php?id=$id'"
			." class='side'>$title</a><br>"
			."<span class='small2'>".$body[0]."</span>\n";
	}
}


/*
 * some tomorrow
 */
// check if tomorrow is in the next month = last day of this month
if(!count($tomorrow_events) && $ec_is_this_month
	&& $ec_today['mday']==date("t")) {
	$tomorrow = mktime(0, 0, 0, $ec_today['mon'], $ec_today['mday']+1,
		$ec_today['year']);
	$tomorrow = getdate($tomorrow);

	$events = ec_get_events($tomorrow['mday'], $tomorrow['mon'],
		$tomorrow['year'], "day", false);
	foreach($events as $day => $more) {
		foreach($more as $ev_id => $day_data) {
			$tomorrow_events[$ev_id] = $day_data['ev_title'];
		}
	}
}
if(count($tomorrow_events)) {
	echo "<p><b>".$locale['EC202'].":</b><br>\n";
	foreach($tomorrow_events as $id => $title) {
		echo $bullet." <a href='$path/view_event.php?id=$id'"
			." class='side'>$title</a><br>\n";
	}
}



/*
 * birthday
 */
if($ec_settings['show_birthday_in_panel']
	&& ec_check_access($ec_settings['show_birthday_to_group'])
	&& $ec_is_this_month) {

	$query_id = dbquery("SELECT user_name, user_birthdate, user_id,"
		." user_avatar"
		." FROM ".DB_PREFIX."users"
		." WHERE MONTH(user_birthdate)='$ec_month'"
		." AND DAYOFMONTH(user_birthdate)='".$ec_today['mday']."'");
	if(dbrows($query_id)) {
		echo "<p><img src='$path/icons/birthday.gif'"
			." alt='' align='bottom'> "
			."<b>".$locale['EC205'].":</b>"
			."<div align='center'>";
		while($data = dbarray($query_id)) {
			if(empty($data['user_avatar'])) {
				$img = INFUSIONS."aw_ecal_panel/icons/noav.gif";
			} else {
				$img = BASEDIR."images/avatars/"
					.$data['user_avatar'];
			}
			echo "<p><a href='".BASEDIR."profile.php?lookup="
				.$data['user_id']."' class='side'>"
				."<img src='$img' alt='AVATAR'><br>"
				.$data['user_name']."</a>\n";
		}
		echo "</div>\n";
	}
}

closeside();

?>
