<?php
/***************************************************************************
 *   awEventCalendar                                                       *
 *                                                                         *
 *   Copyright (C) 2006-2007 Artur Wiebe                                   *
 *   wibix@gmx.de                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
define("EC_BREAK",	"---br---");

define("EC_REP_YEAR",	1);// repeat on that day and month every year
define("EC_REP_MONTH",	2);// repeat on that day every month
define("EC_REP_WEEK",	4);// repeat on that day of week


//0: no error
define("EC_ELOGIN",	1);
define("EC_EDB",	2);
define("EC_ESTATUS",	3);
define("EC_EACCESS",	4);
define("EC_EIMG",	5);
define("EC_EDATE",	6);


if(file_exists(INFUSIONS."aw_ecal_panel/locale/".$settings['locale'].".php")) {
	include INFUSIONS."aw_ecal_panel/locale/".$settings['locale'].".php";
} else {
	include INFUSIONS."aw_ecal_panel/locale/Russian.php";
}


?>
<script type='text/javascript'>
function ec_confirm_delete() {
	return confirm("<?php echo $locale['EC006']; ?>");
}
</script>
<?php


// settings
$query_id = dbquery("SELECT * FROM ".DB_PREFIX."aw_ec_settings");
$ec_settings = dbarray($query_id);


define("PIC_PATH",	INFUSIONS."aw_ecal_panel/pics/");

define('iEC_ADMIN',	ec_check_access($ec_settings['edit_group']));

$ec_bullet = "<img src='".THEME."images/bullet.gif' alt='-'>";


unset($ec_year, $ec_month, $ec_mday);
if(isset($_GET['y']) && isNum($_GET['y'])) {
	$ec_year = $_GET['y'];
} else {
	$ec_year = date("Y");
}
if(isset($_GET['m']) && isNum($_GET['m'])) {
	$ec_month = $_GET['m'];
} else {
	$ec_month = date("n");
}
if(isset($_GET['d']) && isNum($_GET['d'])) {
	$ec_mday = $_GET['d'];
} else {
	$ec_mday = date("j");
}


// today - not the same that is shown in the calendar.
$ec_today = getdate(time());
$ec_is_this_month = ($ec_today['mon']==$ec_month && $ec_today['year']==$ec_year);



/*
 * FUNCS
 */
/*
 * extended: with php-fusion user table
 */
function ec_get_events($day, $month, $year, $collect_by, $extended=true)
{
	global $userdata, $ec_settings;

	$events = array();
	$elem = array();
	$and_where = array();
	$where = array();
	$limit = "";

	// where
	if(empty($next)) {
		if(!empty($month)) {
			$where[] = "(ev_repeat='".EC_REP_MONTH."'"
				." OR MONTH(ev_start)='$month')";
		}
		if(!empty($day)) {
			$where[] = "DAYOFMONTH(ev_start)='$day'";
		}
		if(!empty($year)) {
			$where[] = "(ev_repeat='".EC_REP_YEAR."'"
				." OR YEAR(ev_start)='$year')";
		}
	} else {
		$where = array();
	}
	$where = implode(" AND ", $where);
	$and_where[] = "(ev_repeat='".EC_REP_WEEK."' OR ($where))";


	// access - edit group - no access limit
	if(iEC_ADMIN) {
		//
	} elseif(iMEMBER) {
		$and_where[] = "(((ev_status='0' AND ev_private='0')"
			." OR ec.user_id='".$userdata['user_id']."')"
			." AND ".groupaccess("ev_access").")";
	} else {
		$and_where[] = "(ev_status='0' AND ev_private='0'"
			." AND ev_access='0')";
	}

	$query = "SELECT DAYOFMONTH(ev_start) AS day, ev_repeat,"
		." ev_title, ev_id, ev_access, YEAR(ev_start) AS year,"
		." MONTH(ev_start) AS month, DAYOFWEEK(ev_start) AS wday,"
		." ev_private, ec.user_id, ev_timestamp,";
	if($extended) {
		$query .= " user_name, ev_allow_logins, ev_status,";
	}
	$query .= ""
//FIXME		." MINUTE(ev_start) AS min, HOUR(ev_start) AS hour,"
		." ev_body, DATE_FORMAT(ev_start,
			'".$ec_settings['date_fmt']."') AS date,"
		." ev_no_smileys"
		." FROM ".DB_PREFIX."aw_ec_events AS ec";
	if($extended) {
		$query .= " LEFT JOIN ".DB_PREFIX."users USING(user_id)";
	}
	if(count($where)) {
		$query .= " WHERE ".implode(" AND ", $and_where);
	}
	$query .= " $limit"
		." ORDER BY DAYOFMONTH(ev_start) ASC, ev_start ASC";

	$query_id = dbquery($query);
	while($ev = dbarray($query_id)) {
		$ev_id = $ev['ev_id'];
		$elem = $ev;
		if($collect_by=="day") {
//FIXME-??? only used in calendar.php once
			$events[$ev['day']][$ev_id] = $elem;

			// repeat weekly events
			if($ev['ev_repeat']==EC_REP_WEEK) {
				$first_wday = date("w", mktime(12, 0, 0,
					$month, 1, $year));//FIXME
				for($i=$ev['wday']-$first_wday;
						$i<=31; $i+=7) {
					$events[$i][$ev_id] = $elem;
				}
			}
		} else {
			$events[$ev['month']][$ev['day']][] = $elem;

			// repeat monthly events
			if($ev['ev_repeat']==EC_REP_MONTH) {
				for($i=1; $i<=12; ++$i) {
					if($i!=$ev['month']) {
						$events[$i][$ev['day']][] = $elem;
					}
				}
			// repeat weekly events
			} elseif($ev['ev_repeat']==EC_REP_WEEK) {
				$this_date = mktime(12, 0, 0,
					$ev['month'], $ev['day'], $ev['year']);
				$this_day = getdate($this_date);
				$this_day = $this_day['yday'];
				for($i=0; $i<=365; ++$i) {
					if((($this_day-$i)%7)==0 && $this_day!=$i) {
						$ts = mktime(12, 0, 0,
							1, 1, $year);
						$ts += $i*60*60*24;
						$in_month = date("n", $ts);
						$elem['day'] = date("j", $ts);
						$events[$in_month][$elem['day']][] = $elem;
					}
				}
			}
		}
	}

	return $events;
}



function ec_check_access($group_id) {
	if(iSUPERADMIN) {
		return true;
	}
        switch($group_id) {
        case 101: return iMEMBER;
        case 102: return iADMIN;
        case 103: return iSUPERADMIN;
        default:  return checkGroup($group_id);
        }
	return checkGroup($id);
}


function ec_get_menu()
{
	global $locale, $ec_settings;
	$menu = "";
	$path = INFUSIONS."aw_ecal_panel";

	return "<table border='0' cellspacing='0' cellpadding='0' width='100%'>
<tr>
	<td><b>".$locale['EC400'].":</b> <a href='$path/calendar.php'>"
			.$locale['EC009']."</a>"
		." | <a href='$path/browse.php'>".$locale['EC010']."</a>"
		."<br><a href='$path/search.php'>".$locale['EC011']."</a>"
		." | <a href='$path/edit_event.php'>".$locale['EC100']."</a>"
	."</td>
	<td align='right'><b>".$locale['EC007'].":</b> "
		."<a href='$path/my_events.php'>".$locale['EC001']."</a>"
		." | <a href='$path/my_logins.php'>".$locale['EC008']."</a>"
		."<br>"
		.(iSUPERADMIN
			? "<a href='$path/admin.php'>".$locale['EC700']."</a>"
				." | <a href='$path/admin/misc.php'>"
					.$locale['EC750']."</a> | "
			: "")
		.(iEC_ADMIN
			? "<a href='$path/new_events.php'>".$locale['EC013']
				."</a> | "
			: "")
		."<a href='$path/about.php'>".$locale['EC005']."</a>"
	."</td>
</tr>
</table>
<hr>\n";
}


function ec_render_cal($month, $year, $title, $content,
	$align, $valign, $height, $show_others)
{
	global $locale;

	if($height>0) {
		$height = "height='$height'";
	} else {
		$height = "";
	}

	//
	$thismonth = mktime(12, 0, 0, $month, 1, $year);
	$date = getdate($thismonth);

	if($date['wday']==0) {
		$date['wday'] = 7;
	}
	$offset = $date['wday'] - 1;

	$daysinmonth = date("t", $thismonth);

	/*
	 * line by line
	 */
	echo "<div align='center'>$title</div>\n";

	echo "<table class='awec_table' cellspacing='0' width='100%'>\n";
//	echo "<caption>".$locale['EC400']."</caption>\n";

	// days of week
	echo "<tr>";
	for($i=1; $i<=7; ++$i) {
		echo "<td width='13%' class='awec_dayofweek'>"
			.$locale['EC901'][$i]."</td>";
	}
	echo "</tr>";

	// start with offset
	echo "<tr>\n";
	for($i=0; $i<$offset; ++$i) {
		echo "<td class='awec_empty'></td>\n";
	}
	// start month
	$col = $offset;
	for($i=1; $i<=$daysinmonth; ++$i) {
		echo "<td class='".$content[$i]['style']."' align='$align'"
			." valign='top' $height>"
			.$content[$i]["data"]."</td>\n";

		// new line
		if((++$col%7)==0) {
			echo "</tr>\n<tr>\n";
			$col = 0;
		}
	}
	for($i=0; $i<(7-$col); $i++) {
		echo "<td class='awec_empty'></td>\n";
	}
	echo "</tr>\n";
	echo "</table>\n";
}

if(!function_exists("ec_render_event")) {
function ec_render_event($event, $target="")
{
	global $locale;

	$body = str_replace(EC_BREAK, "", $event['ev_body']);
	if(!$event['ev_no_smileys']) {
		$body = parsesmileys($event['ev_body']);
	}
	$body = nl2br(parseubb($body));

	$admin_stuff = array();
	if($event['ev_allow_logins']) {
		$admin_stuff[] = "<a href='view_event.php?id="
			.$event['ev_id']."#logins'>".$locale['EC008']."</a>";
	}
	if($event['is_admin']) {
		$admin_stuff[] = "<a href='edit_event.php?id="
			.$event['ev_id']."'>".$locale['EC304']."</a>";
		$admin_stuff[] = "<a href='edit_event.php?id="
			.$event['ev_id']."&amp;status=1$target'>"
				.($event['ev_status']
					? $locale['EC306']
					: $locale['EC307']
				)."</a>";
		$admin_stuff[] = "<a href='edit_event.php?id="
				.$event['ev_id']."&amp;del=1$target'"
			." onClick='return ec_confirm_delete();'>"
			.$locale['EC305']."</a>";
	}
	if(count($admin_stuff)) {
		$admin_stuff = implode(" | ", $admin_stuff);
	} else {
		$admin_stuff = "";
	}

	if($event['ev_private']) {
		$more = "<img src='icons/locked.gif' alt=''"
			." title='".$locale['EC108']."'>";
	} else {
		$more = "<b>".$locale['EC116'].":</b> "
			.getgroupname($event['ev_access']);
	}
	if($event['ev_repeat']) {
		$more .= "<br><b>".$locale['EC107'].":</b> "
			.$locale['EC125'][$event['ev_repeat']];
	}

	if($event['ev_status']) {
		$status = "<tr><td align='center' valign='center' class='forum-caption' height='50'><strong>"
			.$locale['EC301']."</strong></td></tr>\n";
	} else {
		$status = "";
	}

	echo "<p>
<table border='0' width='100%' cellspacing='1' cellpadding='0' class='tbl-border'>
$status
<tr>
	<td class='tbl2'>
	<table width='100%'>
	<tr>
		<td width='1%'><img src='icons/event.gif' alt=''></td>
		<td><span class='small2'>".$event['date']."</span><br>
		<font size='+1'><b>".$event['ev_title']."</b></font></td>
		<td valign='top' align='right'>$more</td>
	</tr>
	</table>
	</td>
</tr>
<tr>
	<td class='tbl1'>$body</td>
</tr>
<tr>
	<td class='tbl2'>
	<table width='100%'>
	<tr>
		<td><span class='small2'><a href='".BASEDIR."profile.php"
			."?lookup=".$event['user_id']."'>".$event['user_name']
				.""."</a> - ".showdate("shortdate",
				$event['ev_timestamp'])."</span></td>
		<td align='right'>$admin_stuff</td>
	</tr>
	</table>
	</td>
</tr>
</table>\n";
}
}


function ec_get_bb_smileys($form, $show_no_smileys_field, $smileys_off) {
	global $locale;
	$retval = "<input type='button' value='b' class='button' style='font-weight:bold;' onClick=\"addText('$form', '[b]', '[/b]');\">
<input type='button' value='i' class='button' style='font-style:italic;' onClick=\"addText('$form', '[i]', '[/i]');\">
<input type='button' value='u' class='button' style='text-decoration:underline;' onClick=\"addText('$form', '[u]', '[/u]');\">
<input type='button' value='url' class='button' onClick=\"addText('$form', '[url]', '[/url]');\">
<input type='button' value='mail' class='button' onClick=\"addText('$form', '[mail]', '[/mail]');\">
<input type='button' value='img' class='button' onClick=\"addText('$form', '[img]', '[/img]');\">
<input type='button' value='center' class='button' onClick=\"addText('$form', '[center]', '[/center]');\">
<input type='button' value='small' class='button' onClick=\"addText('$form', '[small]', '[/small]');\">
<input type='button' value='code' class='button' onClick=\"addText('$form', '[code]', '[/code]');\">
<input type='button' value='quote' class='button' onClick=\"addText('$form', '[quote]', '[/quote]');\">
<br><br>"
	.displaysmileys($form);
	if($show_no_smileys_field) {
		$retval .= "<br><input type='checkbox' name='disable_smileys'"
			.($smileys_off ? " checked" : "").">".$locale['EC112'];
	}
	return $retval;
}


?>
