<?php
/*---------------------------------------------------+
| PHP-Fusion 6 Content Management System
+----------------------------------------------------+
| Copyright  2002 - 2006 Nick Jones
| http://www.php-fusion.co.uk/
+----------------------------------------------------+
| Released under the terms & conditions of v2 of the
| GNU General Public License. For details refer to
| the included gpl.txt file or visit http://gnu.org
+----------------------------------------------------+
| Modified by PHP-Fusion SF Group
| Copyright  2007 by SF
| http://www.rus-phpfusion.com/
+----------------------------------------------------*/

/* Profile Page settings */

// set the number of results being displayed for all listings in the normal profile view.
$profile_sql['normal_limit'] = 2;

// set the number of results being displayed in the listing view.
$profile_sql['list_limit'] = 20;
// set the maximum number of query results for the listing view.
$profile_sql['list_max_history'] = 200;

// set the width for the profile table.
$profile_width = 600;

// do you want to include side_right.php
$profile_include_sideright = true;

// color value for the named user levels.. Super Administartor, Administrator and Member.
$rank_color['103'] = "#CC0000";
$rank_color['102'] = "#006600";
$rank_color['101'] = "#3333CC";


// no need to edit below this line..
require_once "maincore.php";
require_once "subheader.php";
require_once "side_left.php";

// turn on or off the listing of forum threads, forum posts, news items and articles.
// set to true for on, false for off.

$profile_display['forum_threads'] = true;
$profile_display['forum_posts'] = true;
$profile_display['news_items'] = true;
$profile_display['articles'] = true;

include LOCALE.LOCALESET."members-profile.php";
include LOCALE.LOCALESET."user_fields.php";
if (file_exists(LOCALE.LOCALESET."members-profile-mod.php")) {
	include LOCALE.LOCALESET."members-profile-mod.php";
} else {
	include LOCALE."English/members-profile-mod.php";
}
include_once INCLUDES."countries.php";

if (isset($_GET['lookup']) && isNum($_GET['lookup'])) define('lookup', $_GET['lookup']);
if (isset($_GET['group_id']) && isNum($_GET['group_id'])) define('group_id', $_GET['group_id']);


if (defined('lookup') && !defined('group_id')) {

	$list_types = array();
	foreach ($profile_display as $key => $value)
	{
		if ($value) array_push($list_types, $key);
	}
	
	// checking to see if we should use a list type layout or the normal profile layout
	if (isset($_GET['list'])) {
		if (!in_array($_GET['list'], $list_types)) fallback(FUSION_SELF."?lookup=".lookup);
		define('currentlist', $_GET['list']);
	} else {
		define('currentlist', 'profile');
	}
	
	$result = dbquery("SELECT * FROM ".$db_prefix."users WHERE user_id='".lookup."'");
	if (dbrows($result) == 1) {

		/* start: profile page generation when the $_GET['lookup'] is found in the users db table. */
		
		$data = dbarray($result);
		$button_width = 100;
		$data['user_location'] = csm_getLocation($data['user_location']);
		opentable($locale['420']);
		echo "<br>\n<table align='center' cellpadding='0' cellspacing='0' width='".$profile_width."'>\n<tr>\n<td>\n";
		
		$profile = "<table cellpadding='0' cellspacing='1' class='tbl-border' width='100%'>\n<tr>\n";
		# start of first cell
		$profile .= "<td align='center' class='tbl1' valign='top'>\n";
		
		// adding user avatar if exists
		if ($data['user_avatar'] && file_exists(IMAGES."avatars/".$data['user_avatar'])) {
			if ($size = @getimagesize(IMAGES."avatars/".$data['user_avatar'])) { if ($size[0] > $button_width && currentlist == 'profile') $button_width = $size[0]; }
			$profile .= "<img alt='' src='".IMAGES."avatars/".$data['user_avatar']."'>";
			if (currentlist == 'profile') $profile .= "<hr>\n";
		} elseif (currentlist != 'profile') $profile .= "<div style='width:".$button_width."px'></div>\n";

		$button_style = "style='margin-bottom:1px;width:".$button_width."px'";
		$added = false;
		$buttons_buffer = "";
		$popup_buttons = "";
		$popup_add = "";
		
		// user email button
		if ($data['user_hide_email'] != 1 || iADMIN) {
			$added = true;
			$popup_buttons .= ",'email'";
			$inherit = str_replace("@","&#64;",$data['user_email']);
			$buttons_buffer .= "<input class='button' type='button' onclick=\"popup_show('email');\" ".$button_style." title='".$inherit."' value='".$locale['u051']."'>";
			$buttons_buffer .= (currentlist == 'profile' ? "<br>" : "&nbsp;")."\n";
			$popup_add .= "<span id='popup_email' style='display:none;'><a href='mailto:".$inherit."'>".$inherit."</a></span>\n";
		}
		// user website button
		if ($data['user_web']) {
			$added = true;
			$popup_buttons .= ",'web'";
			$inherit = (!strstr($data['user_web'], "http://") ? "http://" : "").$data['user_web'];
			$buttons_buffer .= "<input class='button' onclick=\"popup_show('web');\" ".$button_style." title='".$inherit."' type='button' value='".$locale['u052']."'>";
			$buttons_buffer .= (currentlist == 'profile' ? "<br>" : "&nbsp;")."\n";
			$popup_add .= "<span id='popup_web' style='display:none;'><a href='".$inherit."' target='_blank'>".$inherit."</a></span>\n";
		}
		// user pm button
		if (!isset($userdata['user_id']) || $data['user_id'] != $userdata['user_id']) {
			$added = true;
			$inherit = "messages.php?msg_send=".$data['user_id'];
			$buttons_buffer .= "<input class='button' onclick=\"window.location = '".$inherit."';\" ".$button_style." title='".$locale['u060']."' type='button' value='".$locale['u053']."'>";
			$buttons_buffer .= (currentlist == 'profile' ? "<br>" : "&nbsp;")."\n";
		}
		
		// making the aim, icq, msn, yahoo buttons only available in the normal profile lookup.
		if (currentlist == 'profile') {
			if ($data['user_aim'] || $data['user_icq'] || $data['user_msn'] || $data['user_yahoo']) {
				if ($added) $buttons_buffer .= "<hr>\n";
				$added = false;
		
				// user aim button
				if ($data['user_aim']) { 
					$added = true;
					$popup_buttons .= ",'aim'";
					$buttons_buffer .= "<input class='button' onclick=\"popup_show('aim');\" ".$button_style." title='".$data['user_aim']."' type='button' value='".$locale['pm100']."'><br>\n";
					$popup_add .= "<span id='popup_aim' style='display:none;'>".$data['user_aim']."</span>\n";
				}
				// user icq button
				if ($data['user_icq']) { 
					$added = true;
					$popup_buttons .= ",'icq'";
					$buttons_buffer .= "<input class='button' onclick=\"popup_show('icq');\" ".$button_style." title='".$data['user_icq']."' type='button' value='".$locale['pm101']."'><br>\n";
					$popup_add .= "<span id='popup_icq' style='display:none;'>".$data['user_icq']."</span>\n";
				}
				// user msn button
				if ($data['user_msn']) { 
					$added = true;
					$popup_buttons .= ",'msn'";
					$buttons_buffer .= "<input class='button' onclick=\"popup_show('msn');\" ".$button_style." title='".$data['user_msn']."' type='button' value='".$locale['pm102']."'><br>\n";
					$popup_add .= "<span id='popup_msn' style='display:none;'>".$data['user_msn']."</span>\n";
				}
				// user yahoo button
				if ($data['user_yahoo']) { 
					$added = true;
					$popup_buttons .= ",'yahoo'";
					$buttons_buffer .= "<input class='button' onclick=\"popup_show('yahoo');\" ".$button_style." title='".$data['user_yahoo']."' type='button' value='".$locale['pm103']."'><br>\n";
					$popup_add .= "<span id='popup_yahoo' style='display:none;'>".$data['user_yahoo']."</span>\n";
				}
			}
		}
		
		// user ip button
		if (iSUPERADMIN) {
			if ($added && currentlist == 'profile') $buttons_buffer .= "<hr>\n";
			$popup_buttons .= ",'ip'";
			$buttons_buffer .= "<input class='button' onclick=\"popup_show('ip');\" ".$button_style." title='".$data['user_ip']."' type='button' value='".$locale['pm104']."'>";
			$buttons_buffer .= (currentlist == 'profile' ? "<br>" : "&nbsp;")."\n";
			$popup_add .= "<span id='popup_ip' style='display:none;'>".$data['user_ip']."</span>\n";
		}
		
		// add the buttons to the profile variable here in the normal profile lookup
		if (currentlist == 'profile') $profile .= $buttons_buffer."<br>\n";
		$profile .= "</td>\n";
		# end of first cell
		
		# start of second cell
		$profile .= "<td class='tbl1' valign='top' width='100%'>\n";
		$profile .= "<table cellpadding='0' cellspacing='0' width='100%'>\n";

		$profile .= "<tr>\n";
		// user name, rank and rank color prefix
		$rank = "<font color='".$rank_color[$data['user_level']]."'>".getuserlevel($data['user_level'])."</font>";
	
		$profile .= "<td nowrap><strong>".$data['user_name']."</strong><br>".$rank."</td>\n";
		// user online / offline status		
		$lastvisit = (time() - $data['user_lastvisit']);
		if ($lastvisit < 60) $status = "<font color='#006600'>".$locale['pm000']."</font>";
		elseif ($lastvisit < 300) $status = "<font color='#006600'>".$locale['pm001']."</font>";
		else $status = "<font color='#AA0000'>".$locale['pm002']."</font>";
		$profile .= "<td align='right' valign='bottom'>".$status."</td>\n";
		$profile .= "</tr>\n";

		// divider
		$profile .= "<tr>\n<td colspan='2'><br><hr></td>\n</tr>\n";

		if (currentlist == 'profile') {
			// user location
			$profile .= "<tr><td class='small' nowrap width='30%'>".$locale['u009']."</td><td class='small2'>".($data['user_location'] ? $data['user_location'] : $locale['u048'])."</td>\n</tr>\n";
			// user birthday
			if ($data['user_birthdate'] != "0000-00-00") {
				$months = explode("|", $locale['months']);
				$user_birthdate = explode("-", $data['user_birthdate']);
				$birthdate = $months[number_format($user_birthdate['1'])]." ".number_format($user_birthdate['2'])." ".$user_birthdate['0'];
			} else {
				$birthdate = $locale['u048'];
			}
			
			$profile .= "<tr><td class='small' nowrap width='30%'><b>".$locale['UGM_000']."</b></td>
<td class='small2'>".($data['user_gender'] != 0 ? ($data['user_gender'] == 1 ? $locale['UGM_001'] : $locale['UGM_002']) : $locale['u048'])."</td></tr>";
			
			$profile .= "<tr><td class='small' nowrap width='30%'>".$locale['u010']."</td><td class='small2'>".$birthdate."</td>\n</tr>\n";
			// divider
			$profile .= "<tr>\n<td colspan='2'><br><hr></td>\n</tr>\n";
			// user joined
			$profile .= "<tr>\n<td class='small' width='30%'>".$locale['u040']."</td><td class='small2'>".showdate("longdate", $data['user_joined'])."</td>\n</tr>\n";
			// user lastvisit
			$profile .= "<tr>\n<td class='small' width='30%'>".$locale['u044']."</td><td class='small2'>".($data['user_lastvisit'] != 0 ? showdate("longdate", $data['user_lastvisit']) : $locale['u049'])."</td>\n</tr>\n";
			// user shoutbox posts
			$profile .= "<tr>\n<td class='small' width='30%'>".$locale['u041']."</td><td class='small2'>".number_format(dbcount("(shout_id)", "shoutbox", "shout_name='".$data['user_id']."'"))."</td>\n</tr>\n";
			// user comments posted
			$profile .= "<tr>\n<td class='small' width='30%'>".$locale['u042']."</td><td class='small2'>".number_format(dbcount("(comment_id)", "comments", "comment_name='".$data['user_id']."'"))."</td>\n</tr>\n";
			// user forum posts
			$profile .= "<tr>\n<td class='small' width='30%'>".$locale['u043']."</td><td class='small2'>".number_format($data['user_posts'])."</td>\n</tr>\n";
			
			// user groups
			if ($data['user_groups']) {
				// divider
				$profile .= "<tr>\n<td colspan='2'><br><hr></td>\n</tr>\n";
				$usergroups = "";
				$user_groups = (strpos($data['user_groups'], ".") == 0 ? explode(".", substr($data['user_groups'], 1)) : explode(".", $data['user_groups']));
				for ($i = 0;$i < count($user_groups);$i++) {
					$usergroups .= "<a class='small2' href='".FUSION_SELF."?group_id=".$user_groups[$i]."'><strong>".getgroupname($user_groups[$i])."</strong></a>";
					if ($i != (count($user_groups)-1)) { $usergroups .= ","; } 
				}
				$profile .= "<tr>\n<td class='small' width='30%'>".$locale['423']."</td><td class='small2'>".$usergroups."</td>\n</tr>\n";
			}
		} else {
			// add the buttons to the profile variable here when not in the normal profile lookup
			$profile .= "<tr>\n<td colspan='2'>".$buttons_buffer."</td>\n</tr>\n";
		}

		$profile .= "</table>\n";
		if (currentlist == 'profile') $profile .= "<br>\n";
		$profile .= "</td>\n";
		# end of second cell
		$profile .= "</tr>\n";
		$profile .= "<tr id='popup_profile' style='display:none;'>\n<td class='tbl2' colspan='2'>\n[popup_fields]<br><p align='right' style='padding:0;margin:6px 0 0 0;'><a href=\"javascript:void(0);\" onclick=\"document.getElementById('popup_profile').style.display = 'none';\"></a></p></td>\n</tr>\n";
		$profile .= "</table>\n<br>\n";
	
		$profile = str_replace('[popup_fields]', $popup_add, $profile);
		$profile .= "<script language='javascript' type='text/javascript'>\n";
		if (currentlist == 'profile') {
			$profile .= "function expandcollaps(img, id) {"
			."var currentstatus = img.src.indexOf('_on') == -1 ? '_on' : '_off';"
			."var newstatus = currentstatus == '_on' ? '_off' : '_on';"
			."document.getElementById(id).style.display = newstatus == '_on' ? '' : 'none';"
			."img.src = img.src.replace(newstatus, currentstatus);"
			."};";
		}
		$profile .= "var pboxes = new Array(".substr($popup_buttons, 1).");"
		."function popup_show(what) {"
		."var pbox = document.all ? document.all('popup_profile').style : document.getElementById('popup_profile').style;"
		."for (var i = 0;i < pboxes.length;i++) {"
		."var id = 'popup_' + pboxes[i];"
		."var elm = document.all ? document.all(id) : document.getElementById(id);"
		."elm.style.display = pboxes[i] == what ? 'inline' : 'none';"
		."}"
		."pbox.display = '';"
		."};";
		$profile .= "</script>\n";
			
		$limit = (currentlist == 'profile' ? $profile_sql['normal_limit'] : $profile_sql['list_limit']);
		$rowstart = ((!isset($_GET['rowstart']) || !isNum($_GET['rowstart']) || currentlist == 'profile') ? 0 : $_GET['rowstart']);
		$maxlimit = (currentlist == 'profile' ? ($limit + 1) : $profile_sql['list_max_history']);
		
		foreach ($list_types as $list)
		{
			if (currentlist != 'profile' && $list != currentlist) continue;
			
				switch ($list) {
				
				case 'forum_threads':
					$sql = "SELECT tt.*, tf.* FROM ".$db_prefix."threads tt
					INNER JOIN ".$db_prefix."forums tf USING(forum_id)
					WHERE ".groupaccess('forum_access')." AND thread_author='".lookup."'
					ORDER BY thread_lastpost DESC LIMIT ";
					$result1 = dbquery($sql.$maxlimit);
					$result2 = dbquery($sql.$rowstart.",".$limit);
					
					$colspan = 4; $title = $locale['pm300']; $norows = $locale['pm301'];
					$header = "<tr>\n<td class='tbl2' width='25%'><strong>".$locale['pm201']."</strong></td>\n<td class='tbl2'><strong>".$locale['pm202']."</strong></td>\n<td class='tbl2' width='15%'><strong>".$locale['pm203']."</strong></td>\n<td class='tbl2' width='15%'><strong>".$locale['pm204']."</strong></td>\n</tr>\n";
				break;
				case "forum_posts":
					$sql = "SELECT tp.*, tf.* FROM ".$db_prefix."posts tp
					INNER JOIN ".$db_prefix."forums tf USING(forum_id)
					WHERE ".groupaccess('forum_access')." AND post_author='".lookup."'
					ORDER BY post_datestamp DESC LIMIT ";
					$result1 = dbquery($sql.$maxlimit);
					$result2 = dbquery($sql.$rowstart.",".$limit);
		
					$colspan = 3; $title = $locale['pm400']; $norows = $locale['pm401'];
					$header = "<tr>\n<td class='tbl2' width='25%'><strong>".$locale['pm201']."</strong></td>\n<td class='tbl2'><strong>".$locale['pm205']."</strong></td>\n<td class='tbl2' width='30%'><strong>".$locale['pm206']."</strong></td>\n</tr>\n";
				break;
				
				case 'news_items':
					$sql = "SELECT * FROM ".$db_prefix."news
					WHERE ".groupaccess('news_visibility')." AND (news_start='0'||news_start<=".time().") AND (news_end='0'||news_end>=".time().") AND news_name='".lookup."'
					ORDER BY news_datestamp DESC LIMIT ";
					$result1 = dbquery($sql.$maxlimit);
					$result2 = dbquery($sql.$rowstart.",".$limit);

					$colspan = 2; $title = $locale['pm500']; $norows = $locale['pm501'];
					$header = "<tr>\n<td class='tbl2'><strong>".$locale['pm205']."</strong></td>\n<td class='tbl2' width='30%'><strong>".$locale['pm206']."</strong></td>\n</tr>\n";
				break;
				case 'articles':
					$sql = "SELECT a.*, ac.* FROM ".$db_prefix."articles a
					LEFT JOIN ".$db_prefix."article_cats ac ON a.article_cat=ac.article_cat_id
					WHERE ".groupaccess('ac.article_cat_access')." AND article_name='".lookup."'
					ORDER BY article_datestamp DESC LIMIT ";
					$result1 = dbquery($sql.$maxlimit);
					$result2 = dbquery($sql.$rowstart.",".$limit);
		
					$colspan = 2; $title = $locale['pm600']; $norows = $locale['pm601'];
					$header = "<tr>\n<td class='tbl2'><strong>".$locale['pm205']."</strong></td>\n<td class='tbl2' width='30%'><strong>".$locale['pm206']."</strong></td>\n</tr>\n";
				break;
			}
				
			
			
			$profile .= "<table cellpadding='0' cellspacing='1' class='tbl-border' width='100%'>\n<tr>\n";
			$profile .= "<td class='tbl1' valign='top'>\n";
		
			$profile .= "<table cellpadding='0' cellspacing='1' width='100%'>\n";
			$profile .= "<tr>\n<td colspan='".$colspan."'>";
			if (currentlist == 'profile') {
				$profile .= "<span style='float:left'><strong>".$title." ".$data['user_name']."</strong></span><span style='float:right'>";
				if (dbrows($result1) > $limit) $profile .= "<a href='".FUSION_SELF."?lookup=".$data['user_id']."&amp;list=".$list."' style='vertical-align:middle'>".$locale['pm207']."</a>&nbsp;";
				$profile .= "<img alt='' onclick=\"expandcollaps(this, '".$list."')\" src='".THEME."images/panel_".(dbrows($result1) == 0 ? "on" : "off").".gif' style='cursor:pointer;vertical-align:middle'></span>";
			} else {
				$profile .= "<strong>".$title." ".$data['user_name']."</strong>";
			}
			$profile .= "</td>\n</tr>\n";
			$profile .= "<tr>\n<td colspan='".$colspan."'><hr></td>\n</tr>\n";
			$profile .= "<tbody id='".$list."'".(currentlist == 'profile' && dbrows($result1) == 0 ? " style='display:none'" : "").">\n";
			if (dbrows($result1) == 0) { 
				$profile .= "<tr><td align='center' class='tbl' colspan='".$colspan."'><strong>".$data['user_name']."</strong> ".$norows."</td>\n</tr>\n";
			} else {
				$profile .= $header;
				while ($row = dbarray($result2)) {
					
						switch ($list) {
						
						case 'forum_threads': 
							$replies = dbcount("(thread_id)", "posts", "thread_id='".$row['thread_id']."'");
							$profile .= "<tr>\n<td class='tbl'>".trimlink($row['forum_name'], 30)."</td>\n"
							."<td class='tbl'><a style='font-weight:normal;' href='".FORUM."viewthread.php?forum_id=".$row['forum_id']."&amp;thread_id=".$row['thread_id']."' title='".$row['thread_subject']."'>".trimlink($row['thread_subject'], 30)."</a></td>\n"
							."<td class='tbl'>".$row['thread_views']."</td>\n"
							."<td class='tbl'>".ceil($replies-1)."</td>\n</tr>\n";
						break;
						case "forum_posts":
							$replies = dbcount("(thread_id)", "posts", "thread_id='".$row['thread_id']."'");
							$rstart = ($replies > 20 ? "rowstart=".((ceil($replies / 20)-1)*20)."&amp;" : "");
							$profile .= "<tr>\n<td class='tbl'>".trimlink($row['forum_name'], 30)."</td>\n"
							."<td class='tbl'><a style='font-weight:normal;' href='".FORUM."viewthread.php?".$rstart."forum_id=".$row['forum_id']."&amp;thread_id=".$row['thread_id']."&amp;pid=".$row['post_id']."#post_".$row['post_id']."' title='".$row['post_subject']."'>".trimlink($row['post_subject'], 30)."</a></td>\n"
							."<td class='tbl'>".showdate("forumdate", $row['post_datestamp'])."</td>\n</tr>\n";
						break;
						
						case 'news_items':
							$profile .= "<tr>\n<td class='tbl'><a style='font-weight:normal;' href='".BASEDIR."news.php?readmore=".$row['news_id']."'>".trimlink($row['news_subject'], 50)."</a></td>\n"
							."<td class='tbl'>".showdate("forumdate", $row['news_datestamp'])."</td>\n</tr>\n";
						break;
						case 'articles':
							$profile .= "<tr>\n<td class='tbl'><a style='font-weight:normal;' href='".BASEDIR."readarticle.php?article_id=".$row['article_id']."'>".trimlink(stripslashes($row['article_subject']), 50)."</a></td>\n"
							."<td class='tbl'>".showdate("forumdate", $row['article_datestamp'])."</td>\n</tr>";
						break;
					}
					
						
					
					
				}
			}
			$profile .= "</tbody>\n</table>\n";
			$profile .= "</td>\n";
			$profile .= "</tr>\n</table>\n<br>\n";
			if (currentlist != 'profile') {
				$profile .= "<table cellpadding='0' cellspacing='0' width='100%'><tr><td align='left'><a href='".FUSION_SELF."?lookup=".lookup."'>".$locale['pm208']."</a></td>"
				."<td align='right'>".(dbrows($result1) > $limit ? makePageNav($rowstart,$limit,dbrows($result1),3,FUSION_SELF."?lookup=".lookup."&amp;list=".$list."&amp;") : "&nbsp;")."</td></tr></table>\n<br>\n";
			}				
		}		

		echo $profile;
		echo "</td>\n</tr>\n</table>\n<br>\n";
		closetable();
		
		/* end: profile page generation when the $_GET['lookup'] is found in the users db table. */

	} else {

		/* start: profile page generation when the $_GET['lookup'] is not found in the users db table. */

		opentable($locale['420']." - ".$locale['pm200']);
		echo "<br>\n<table align='center' cellpadding='0' cellspacing='1' class='tbl-border' width='".$profile_width."'>\n<tr>\n<td align='center' class='tbl1'>\n";
		echo str_replace("{LOOKUP}", "<strong>".lookup."</strong>", $locale['pm209'])."\n";
		echo "</td>\n</tr>\n</table>\n<br>\n";
		closetable();

		/* end: profile page generation when the $_GET['lookup'] is not found in the users db table. */
	}		
} elseif (defined('group_id') && !defined('lookup')) {
	$result = dbquery("SELECT * FROM ".$db_prefix."user_groups WHERE group_id='".group_id."'");
	if (dbrows($result)) {

		/* start: user group page generation when the $_GET['group_id'] is found in the user_goups db table. */

		$data = dbarray($result);
		$result = dbquery("SELECT * FROM ".$db_prefix."users WHERE user_groups REGEXP('^\\\.".group_id."$|\\\.".group_id."\\\.|\\\.".group_id."$') ORDER BY user_level DESC, user_name");
		
		opentable($locale['410']);
		echo "<br>\n<table align='center' cellpadding='0' cellspacing='1' class='tbl-border' width='".$profile_width."'>\n<tr>\n<td class='tbl1'>\n";
		echo "<table cellpadding='0' cellspacing='0' width='100%'>\n";
		
		echo "<tr>\n<td class='tbl'><strong>".$data['group_name']."</strong></td>\n"
		."<td align='right' class='tbl'><span class=' small2'>( ".sprintf((dbrows($result) == 1 ? $locale['411'] : $locale['412']), dbrows($result))." )</span></td>\n</tr>\n";

		echo "<tr>\n<td colspan='2'><hr></td>\n</tr>\n";

		while ($data = dbarray($result)) {
			echo "<tr>\n<td class='tbl' width='75%'><a href='".FUSION_SELF."?lookup=".$data['user_id']."'>".$data['user_name']."</a></td>"
			."<td class='tbl' nowrap><font color='".$rank_color[$data['user_level']]."'>".getuserlevel($data['user_level'])."</font></td>\n</tr>\n";
		}
		echo "</table>\n";
		echo "</td>\n</tr>\n</table>\n<br>\n";
		closetable();
		
		/* end: user group page generation when the $_GET['group_id'] is found in the user_goups db table. */	
	} else {
	
		/* start: user group page generation when the $_GET['group_id'] is not found in the user_goups db table. */

		opentable($locale['410']." - ".$locale['pm200']);
		echo "<br>\n<table align='center' cellpadding='0' cellspacing='1' class='tbl-border' width='".$profile_width."'>\n<tr>\n<td align='center' class='tbl1'>\n";
		echo str_replace("{GROUP_ID}", "<strong>".group_id."</strong>", $locale['pm210'])."\n";
		echo "</td>\n</tr>\n</table>\n<br>\n";
		closetable();

		/* end: user group page generation when the $_GET['group_id'] is not found in the user_goups db table. */	
	}
} else {
	redirect(BASEDIR."index.php");
}


if ($profile_include_sideright) require_once "side_right.php";
else echo "</td>\n";
require_once "footer.php";
?>