<?php
/*---------------------------------------------------+
| PHP-Fusion 6 Content Management System
+----------------------------------------------------+
| Copyright  2002 - 2005 Nick Jones
| http://www.php-fusion.co.uk/
+----------------------------------------------------+
| Released under the terms & conditions of v2 of the
| GNU General Public License. For details refer to
| the included gpl.txt file or visit http://gnu.org
+----------------------------------------------------*/
require_once "../../maincore.php";
require_once BASEDIR."subheader.php";
require_once BASEDIR."side_left.php";

if (file_exists(INFUSIONS."irc_chat/locale/".$settings['locale'].".php")) {
	include INFUSIONS."irc_chat/locale/".$settings['locale'].".php";
} else {
	include INFUSIONS."irc_chat/locale/English.php";
}
include INFUSIONS."irc_chat/irc_config.php";
opentable($title);

$ircconfig = dbarray(dbquery("SELECT * FROM ".$db_prefix."irc_config"));

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html><head>
<meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">
<title><?=$title?></title>
<link rel="shortcut icon" href="favicon.ico">
<link rel="stylesheet" type="text/css" href="css.php<?php if ($page == "chat") print "?color=".$color; ?>">
<script language="JavaScript" type="text/javascript" src="chat.js"></script>
</head>

<?php

// ===============================================================================
// == Index Normal ==========================================================
// ===============================================================================

if($page == ""): ?>
<body onLoad="document.login.nick.focus();">

<div align=center>
<form name="login" action="<?=$_SERVER[PHP_SELF]?>" method="<?=$method?>" onSubmit="return RandomNick();">
	<input type="hidden" name="page" value="chat">
	<table width="100%" class="border"><tr><td align=center>
		<table width="100%" cellpadding=18>
			<tr>
				<td align=center valign=top class="tall">
					<hr><?=$headline?><hr><br>
					<?php print logo(); ?>
				</td>
			</tr>
		</table>
		<table width="100%">
			<tr>
				<td align=right class="medium"><?=$locale[IRC103]?>:&nbsp;</td>
				<td><input name="nick" type="text" class="input" value="<?=$nick;?>"></td>
			</tr><tr>
				<td align=right class="medium"><?=$locale[IRC104]?>:&nbsp;</td>
				<td>
					<input name="smileys" type="radio" checked="checked" value="1"><?=$locale[IRC105]?>&nbsp;
					<input name="smileys" type="radio" value="0"><?=$locale[IRC106]?>&nbsp;
				</td>
			</tr>
		</table>
		<table>
			<tr>
				<td align=center height=20><input type="submit" value="<?=$locale[IRC107]?>"></td>
			</tr><tr>
				<td align=center height=20 class="small">
					<a href="<?=$_SERVER[PHP_SELF]?>?page=advanced"><?=$locale[IRC108]?></a>
				</td>
			</tr>
		</table>
	</td></tr></table>
</form>
<?php endif;

// ===============================================================================
// == Index Advanced ========================================================
// ===============================================================================

if($page == "advanced"): ?>
<body onLoad="document.login.nick.focus();">

<div align=center>
<form name="login" action="<?=$_SERVER[PHP_SELF]?>" method="<?=$method?>" onSubmit="return chkForm();">
	<input type="hidden" name="page" value="chat">
	<table width="100%" class="border"><tr><td align=center>
		<table width="100%" cellpadding=18>
			<tr>
				<td align=center valign=top class="tall">
					<hr><?=$headline?><hr><br>
					<?php print logo(); ?>
				</td>
			</tr>
		</table>
		<table width="80%">
			<tr>
				<td align=right class="medium"><?=$locale[IRC103]?>:&nbsp;</td>
				<td><input name="nick" type="text" class="input" value="<?=$nick;?>"></td>
			</tr><tr>
				<td align=right class="medium"><?=$locale[IRC109]?>:&nbsp;</td>
				<td><input name=pass type="password" class="input"></td>
			</tr><tr>
				<td align=right class="medium"><?=$locale[IRC110]?>:&nbsp;</td>
				<td><input name="chan" type="text" value="<?=$chan?>" class="input"></td>
			</tr><tr>
				<td align=right class="medium"><?=$locale[IRC111]?>:&nbsp;</td>
				<td><input name="host" type="text" value="<?=$host?>" class="input"></td>
			</tr><tr>
				<td align=right class="medium"><?=$locale[IRC112]?>:&nbsp;</td>
				<td>
					<select name="style" size=1 class="input">
						<option><?=$locale[IRC113]?></option>
						<option><?=$locale[IRC114]?></option>
						<option><?=$locale[IRC115]?></option>
					</select>
				</td>
			</tr><tr>
				<td align=right class="medium"><?=$locale[IRC116]?>:&nbsp;</td>
				<td>
					<select name="font" size=1 class="input">
						<option><?=$locale[IRC117]?></option>
						<option selected><?=$locale[IRC118]?></option>
						<option><?=$locale[IRC119]?></option>
						<option><?=$locale[IRC120]?></option>
						<option><?=$locale[IRC121]?></option>
						<option><?=$locale[IRC122]?></option>
					</select>
				</td>
			</tr><tr>
				<td align=right class="medium"><?=$locale[IRC123]?>:&nbsp;</td>
				<td>
					<select name="font2" size=1>
						<option>10</option>
						<option>11</option>
						<option>12</option>
						<option selected>14</option>
						<option>15</option>
						<option>16</option>
					</select>
				</td>
			</tr><tr>
				<td align=right class="medium"><?=$locale[IRC104]?>:&nbsp;</td>
				<td>
					<input name="smileys" type="radio" value="1" checked><?=$locale[IRC105]?>&nbsp;
					<input name="smileys" type="radio" value="0"><?=$locale[IRC106]?>&nbsp;
				</td>
			</tr>
		</table>
		<table>
			<tr>
				<td align=center height=20><input type="submit" value="<?=$locale[IRC107]?>"></td>
			</tr><tr>
				<td align=center height=20 class="small"><a href="<?=$_SERVER[PHP_SELF]?>?page=chat"><?=$locale[IRC124]?></a></td>
			</tr>
		</table>
	</td></tr></table>
</form>
<?php endif;

// ===============================================================================
// == mainpage ==============================================================
// ===============================================================================

if($page == "chat"): ?>
<body class="back">

<div align=center>
	<table width="100%">
		<tr>
			<td class="small" width="100%"><?=$locale[IRC125]?> <a href="<?=$_SERVER[PHP_SELF]?>"><?=$locale[IRC107]?></a></td>
		</tr><tr>
			<td align="center" valign="top" class="color">
				<applet name="pjirc" code=IRCApplet.class archive="irc.jar, pixx.jar" width="100%" height=400>
					<param name="CABINETS" value="irc.cab, securedirc.cab, pixx.cab">
					<param name="nick" value="<?=$nick?>">
					<param name="alternatenick" value="<?=$nick?>??">
					<param name="host" value="<?=$host?>">
					<param name="name" value="<?=$name?>">
					<param name="userid" value="<?=$nick?>">
					<param name="command1" value="<?=$pass?>">
					<param name="command2" value="<?=$channel?>">
					<param name="quitmessage" value="<?=$quit_message?>">
					<param name="soundword1" value="<?=strtolower($nick);?> snd/ding.au">
					<param name="language" value="<?=$language?>">
					<param name="lngextension" value="<?=$langEx?>">
					<param name="soundbeep" value="snd/bell2.au">
					<param name="soundquery" value="snd/ding.au">
					<param name="highlight" value="true">
					<param name="gui" value="pixx">

					<param name="style:sourcefontrule1" value="Status+Channel+Query all <?php print $font." ".$font2; ?>">
<?php
	if($smileys) {
		print "\t\t\t\t\t<param name=\"style:bitmapsmileys\" value=\"true\">\n";
		$i=0; $x=1;
		while(isset($smiley[$i][0])) {
			$k=1;
			while(isset($smiley[$i][$k])) {
				$img = $imgpath."/".$smiley[$i][0].$imgEx;
				$smiley[$i][$k] = str_replace("\\", "", $smiley[$i][$k]);
				print "\t\t\t\t\t<param name=\"style:smiley".$x."\" value=\"".$smiley[$i][$k]." ".$img."\">\n";
				$x++; $k++;
			}
			$i++;
		}
	}

	print "\n";
	if($style == "Default") print "\t\t\t\t\t<param name=\"pixx:nickfield\" value=\"true\">\n";
?>
					<param name="pixx:language" value="pixx-<?=$language?>">
					<param name="pixx:highlightnick" value="true">
					<param name="pixx:styleselector" value="true">
					<param name="pixx:setfontonstyle" value="true">
					<param name="pixx:timestamp" value="true">
					<param name="pixx:mouseurlopen" value="1 2">
					<param name="pixx:mousechanneljoin" value="1 2">
<?php
	print "\t\t\t\t\t<param name=\"pixx:configurepopup\" value=\"true\">\n";

	$i = 0;
	while(isset($popupmenu[$i][0])) {
		print "\t\t\t\t\t<param name=\"pixx:popupmenustring".($i+1)."\" value=\"".$popupmenu[$i][0]."\">\n";
		$i++;
	}

	$i = 0;
	while(isset($popupmenu[$i][0])) {
		$k = 1;
		while(isset($popupmenu[$i][$k])) {
			print "\t\t\t\t\t<param name=\"pixx:popupmenucommand".($i+1)."_".$k."\" value=\"".$popupmenu[$i][$k]."\">\n";
			$k++;
		}
		$i++;
	}

	if(isset($which)) {
		$i=0;
		while(isset($colorset[$i][$which])) {
			print "\t\t\t\t\t<param name=\"pixx:color".$i."\" value=\"".$colorset[$i][$which]."\"> ";
			print $comment[$i][0]."\n";
			$i++;
		}
	}

	print "\t\t\t\t</applet>\n";

// ===============================================================================
// == Smileys ===============================================================
// ===============================================================================

if($smileys): ?>
				<table width="100%" cellspacing=0 cellpadding=0><tr><td>
					<table cellpadding=3 width="100%"><tr>
						<td valign=top width="100%"><img src="img/blank.gif" width=50 height=1 alt="">
<?php
	$i = 0;
	while(isset($smiley[$i][0])) {
		$img = $imgpath."/".$smiley[$i][0].$imgEx;
		print "\t\t\t\t\t\t</td><td valign=top>\n";
		if (is_readable($img)) {
			$size  = GetImageSize($img);
			$smiley[$i][1] = str_replace("'", "\'", $smiley[$i][1]);
			print "\t\t\t\t\t\t\t<a href=\"javascript:smiley('".$smiley[$i][1]."')\">\n";
			print "\t\t\t\t\t\t\t<img src=\"".$img."\" ".$size[3]." border=0 alt=\"".$smiley[$i][1]."\"></a>&nbsp;\n";
		}
		else {
			$smiley[$i][1] = str_replace("'", "\'", $smiley[$i][1]);
			print "\t\t\t\t\t\t\t<a href=\"javascript:smiley('".$smiley[$i][1]."')\" title=\"/".$img." not found\">";
			$smiley[$i][1] = str_replace("\\", "", $smiley[$i][1]);
			print $smiley[$i][1]."</a>&nbsp;\n";
			$warning_smiley = true;
		}
		$i++;
	}
?>
						</td>
					</tr></table>
				</td></tr></table>
<?php endif; ?>
			</td>
		</tr>
	</table><br>
<?php

// ===============================================================================
// == Away/Back Buttons/Input field =========================================
// ===============================================================================

if($buttons): ?>
	<form name="form" action="<?=$_SERVER[PHP_SELF]?>">
	<table width="100%"><tr><td>
		<span class="medium"><?=$locale[IRC126]?>:&nbsp;</span>
		<input name="away_reason" type="text" size=30>
		<input type="button" value="Set Away" onClick="maway(document.form.away_reason.value,'<?=$nick?>')">
		<input type="button" value="Set Back" onClick="mback(document.form.away_reason.value,'<?=$nick?>')">
	</td></tr></table>
	</form>
<?php endif;

// ===============================================================================
// == Warnings ==============================================================
// ===============================================================================

if(isset($warning_smiley) && $warning_smiley): ?>
	<table width="100%" cellpadding=0 cellspacing=0 class="border"><tr><td>
		<table style="background-color: white;" width="100%"><tr>
			<td valign=top class="small"><b><?=$locale[IRC127]?>:&nbsp;</b></td>
			<td valign=top class="small">
				<?=$locale[IRC128]?>
				<b><?=$imgpath?></b> <?=$locale[IRC129]?><br>
				<?=$locale[IRC130]?>
			</td>
		</tr></table>
	</td></tr></table>
<?php endif; endif; ?>
</div>

</body></html>

<?
closetable();

require_once BASEDIR."side_right.php";
require_once BASEDIR."footer.php";
?>